/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.search;

import com.atlassian.bitbucket.AuthorisationException;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.search.SearchException;
import com.atlassian.bitbucket.internal.search.client.Requests;
import com.atlassian.bitbucket.internal.search.client.SearchClient;
import com.atlassian.bitbucket.internal.search.common.events.CodeSearchSuccessfulEvent;
import com.atlassian.bitbucket.internal.search.common.events.RepositoriesSearchSuccessfulEvent;
import com.atlassian.bitbucket.internal.search.common.mapping.FileMapping;
import com.atlassian.bitbucket.internal.search.common.mapping.RepositoryMapping;
import com.atlassian.bitbucket.internal.search.common.util.Optionals;
import com.atlassian.bitbucket.internal.search.common.util.PropertyUtils;
import com.atlassian.bitbucket.internal.search.common.util.Timing;
import com.atlassian.bitbucket.internal.search.indexing.util.Observables;
import com.atlassian.bitbucket.internal.search.search.DetailedRepository;
import com.atlassian.bitbucket.internal.search.search.QueryInvalidException;
import com.atlassian.bitbucket.internal.search.search.QueryInvalidSearchOffsetException;
import com.atlassian.bitbucket.internal.search.search.SearchResponseContext;
import com.atlassian.bitbucket.internal.search.search.SearchService;
import com.atlassian.bitbucket.internal.search.search.UnsuccessfulResponseException;
import com.atlassian.bitbucket.internal.search.search.convert.SearchRepositoryHit;
import com.atlassian.bitbucket.internal.search.search.convert.SearchResponseConverter;
import com.atlassian.bitbucket.internal.search.search.permission.PermissionLevel;
import com.atlassian.bitbucket.internal.search.search.permission.SecurityContext;
import com.atlassian.bitbucket.internal.search.search.query.FileSearchQueryBuilder;
import com.atlassian.bitbucket.internal.search.search.query.Query;
import com.atlassian.bitbucket.internal.search.search.query.RepositorySearchQueryBuilder;
import com.atlassian.bitbucket.internal.search.search.query.SearchQueryBuilder;
import com.atlassian.bitbucket.internal.search.search.query.parser.DetailedRepositorySearchRequestParser;
import com.atlassian.bitbucket.internal.search.search.query.parser.FileSearchQueryParser;
import com.atlassian.bitbucket.internal.search.search.query.parser.QueryEmptyException;
import com.atlassian.bitbucket.internal.search.search.query.parser.QueryParser;
import com.atlassian.bitbucket.internal.search.search.query.parser.RepositoryAndProjectSearchQueryParser;
import com.atlassian.bitbucket.internal.search.search.query.parser.RepositoryFileSearchQueryParser;
import com.atlassian.bitbucket.internal.search.search.query.parser.RepositoryFilterRequestParser;
import com.atlassian.bitbucket.internal.search.search.request.DetailedRepositorySearchRequest;
import com.atlassian.bitbucket.internal.search.search.request.DetailedRepositorySortOrder;
import com.atlassian.bitbucket.internal.search.search.request.RepositoryFilterRequest;
import com.atlassian.bitbucket.internal.search.search.request.RepositoryMatchingFileRequest;
import com.atlassian.bitbucket.internal.search.search.request.SearchPagingInfo;
import com.atlassian.bitbucket.internal.search.search.request.SearchRequest;
import com.atlassian.bitbucket.internal.search.search.result.DefaultDetailedRepositorySearchResult;
import com.atlassian.bitbucket.internal.search.search.result.DefaultFileSearchResult;
import com.atlassian.bitbucket.internal.search.search.result.DefaultRepositorySearchResult;
import com.atlassian.bitbucket.internal.search.search.result.DefaultSearchResult;
import com.atlassian.bitbucket.internal.search.search.result.DetailedRepositorySearchResult;
import com.atlassian.bitbucket.internal.search.search.result.FileHit;
import com.atlassian.bitbucket.internal.search.search.result.FileSearchResult;
import com.atlassian.bitbucket.internal.search.search.result.RepositorySearchResult;
import com.atlassian.bitbucket.internal.search.search.result.SearchResult;
import com.atlassian.bitbucket.internal.search.search.scope.DefaultScope;
import com.atlassian.bitbucket.internal.search.search.scope.Scope;
import com.atlassian.bitbucket.internal.search.search.scope.ScopeResolver;
import com.atlassian.bitbucket.permission.PermissionValidationService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.elasticsearch.client.ES;
import com.atlassian.elasticsearch.client.content.ContentBuilder;
import com.atlassian.elasticsearch.client.query.QueryBuilder;
import com.atlassian.elasticsearch.client.request.Response;
import com.atlassian.elasticsearch.client.search.HighlightFieldDefinition;
import com.atlassian.elasticsearch.client.search.SearchRequestBuilder;
import com.atlassian.elasticsearch.client.search.SearchRequestHighlightBuilder;
import com.atlassian.elasticsearch.client.search.SearchResponse;
import com.atlassian.elasticsearch.client.search.SearchSourceBuilder;
import com.atlassian.elasticsearch.client.search.SortBuilder;
import com.atlassian.event.api.EventPublisher;
import com.codahale.metrics.annotation.Timed;
import com.google.common.collect.Multimap;
import io.atlassian.fugue.Either;
import jakarta.annotation.Nonnull;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import rx.Observable;

@Component
public class DefaultSearchService
implements SearchService {
    private static final Logger log = LoggerFactory.getLogger(DefaultSearchService.class);
    private static final Logger timingLogger = Timing.TIMING_LOGGER;
    private final SearchClient client;
    private final EventPublisher eventPublisher;
    private final SearchQueryBuilder fileSearchQueryBuilder;
    private final QueryParser fileSearchQueryParser;
    private final SearchResponseConverter<FileHit> fileSearchResponseConverter;
    private final PermissionValidationService permissionValidationService;
    private final SearchResponseConverter<Repository> repoFileSearchResponseConverter;
    private final SearchResponseConverter<Repository> repoSearchResponseConverter;
    private final SearchResponseConverter<DetailedRepository> detailedRepoSearchResponseConverter;
    private final RepositoryFileSearchQueryParser repositoryFileSearchQueryParser;
    private final RepositoryFilterRequestParser repositoryFilterRequestParser;
    private final SearchQueryBuilder repositorySearchQueryBuilder;
    private final DetailedRepositorySearchRequestParser detailedRepositorySearchRequestParser;
    private final QueryParser repositorySearchQueryParser;
    private final ScopeResolver scopeResolver;
    private final I18nService i18nService;

    @Autowired
    public DefaultSearchService(SearchClient client, EventPublisher eventPublisher, ScopeResolver scopeResolver, @Qualifier(value="fileSearchResponseConverter") SearchResponseConverter<FileHit> fileSearchResponseConverter, @Qualifier(value="repoSearchResponseConverter") SearchResponseConverter<Repository> repoSearchResponseConverter, @Qualifier(value="repoFileSearchResponseConverter") SearchResponseConverter<Repository> repoFileSearchResponseConverter, @Qualifier(value="detailedRepoSearchResponseConverter") SearchResponseConverter<DetailedRepository> detailedRepoSearchResponseConverter, PermissionValidationService permissionValidationService, RepositoryFilterRequestParser repositoryFilterRequestParser, I18nService i18nService) {
        this.client = client;
        this.eventPublisher = eventPublisher;
        this.scopeResolver = scopeResolver;
        this.fileSearchResponseConverter = fileSearchResponseConverter;
        this.repoSearchResponseConverter = repoSearchResponseConverter;
        this.repoFileSearchResponseConverter = repoFileSearchResponseConverter;
        this.detailedRepoSearchResponseConverter = detailedRepoSearchResponseConverter;
        this.permissionValidationService = permissionValidationService;
        this.i18nService = i18nService;
        this.fileSearchQueryParser = new FileSearchQueryParser();
        this.repositorySearchQueryParser = new RepositoryAndProjectSearchQueryParser();
        this.repositoryFilterRequestParser = repositoryFilterRequestParser;
        this.repositoryFileSearchQueryParser = new RepositoryFileSearchQueryParser();
        this.detailedRepositorySearchRequestParser = new DetailedRepositorySearchRequestParser();
        Multimap<String, String> languageMap = PropertyUtils.getPropertiesAsMultiMap(this.getClass(), "languageMapping.properties");
        this.fileSearchQueryBuilder = new FileSearchQueryBuilder(languageMap);
        this.repositorySearchQueryBuilder = new RepositorySearchQueryBuilder();
    }

    private static boolean showScoreExplanation() {
        return log.isTraceEnabled();
    }

    private static void traceResponse(SearchResponse searchResponse) {
        if (timingLogger.isDebugEnabled()) {
            timingLogger.debug("Timing: Search execution took {} [{} ms], total number of hits: {}", new Object[]{searchResponse.getTook(), searchResponse.getTook().toMillis(), searchResponse.getTotalHitsNumber()});
        }
    }

    @Override
    @Nonnull
    @Timed(name="search.service.filterRepositories", absolute=true)
    public Observable<RepositorySearchResult> filterRepositories(@Nonnull SecurityContext securityContext, @Nonnull RepositoryFilterRequest filterRequest) {
        filterRequest.getOriginId().ifPresent(arg_0 -> ((PermissionValidationService)this.permissionValidationService).validateRepositoryAccessible(arg_0));
        Either<QueryInvalidException, Query> maybeQuery = this.repositoryFilterRequestParser.convertToQuery(filterRequest);
        return filterRequest.getSearchPagingInfo().map(pagingInfo -> this.searchRepositories(maybeQuery, securityContext, (SearchPagingInfo)pagingInfo).flatMap(response -> this.buildRepositorySearchResult((SearchResponseContext)response, (SearchPagingInfo)pagingInfo, this.repoSearchResponseConverter))).orElse(Observable.error((Throwable)new SearchException("Filter request should contain valid repository paging info.")));
    }

    @Override
    @Nonnull
    @Timed(name="search.service.searchFor", absolute=true)
    public Observable<SearchResult> searchFor(@Nonnull SecurityContext securityContext, @Nonnull SearchRequest searchRequest) {
        if (searchRequest.getSearchPagingInfo(SearchRequest.SearchRequestType.CODE).isPresent()) {
            return this.searchForFiles(securityContext, searchRequest);
        }
        if (searchRequest.getSearchPagingInfo(SearchRequest.SearchRequestType.REPOSITORIES).isPresent()) {
            return this.searchForRepositories(securityContext, searchRequest);
        }
        return Observable.error((Throwable)new SearchException("No valid request found"));
    }

    @Override
    @Nonnull
    public Observable<RepositorySearchResult> searchRepositoriesMatchingFile(@Nonnull SecurityContext securityContext, @Nonnull RepositoryMatchingFileRequest request) {
        Objects.requireNonNull(securityContext, "securityContext");
        Objects.requireNonNull(request, "request");
        Either<QueryInvalidException, Query> repositoryQuery = this.repositorySearchQueryParser.parseRawQuery(request.getRawSearchQuery());
        Observable observableRepositoryIds = request.getSearchPagingInfo(SearchRequest.SearchRequestType.REPOSITORIES).map(pagingInfo -> this.searchRepositories(repositoryQuery, securityContext, (SearchPagingInfo)pagingInfo).flatMap(this::buildRepositoryIdList)).orElse(Observable.error((Throwable)new SearchException("Search request should contain repository search paging info")));
        List repositoryIds = (List)Observables.consumeSingle(observableRepositoryIds).getOrElse(Collections.emptyList());
        if (repositoryIds.isEmpty()) {
            log.debug("No repositories matched the query, {}. Returning no results.", (Object)request.getRawSearchQuery());
            return Observable.just((Object)((DefaultRepositorySearchResult.Builder)((DefaultRepositorySearchResult.Builder)((DefaultRepositorySearchResult.Builder)((DefaultRepositorySearchResult.Builder)DefaultRepositorySearchResult.builder().repositories(Collections.emptyList()).totalHitCount(0L).pageNumber(1)).pageSize(0)).offset(0)).isLastPage(true)).build());
        }
        Either<QueryInvalidException, Query> repoFileQuery = this.repositoryFileSearchQueryParser.convertToQuery(request.getRootFileParameter(), repositoryIds);
        return request.getSearchPagingInfo(SearchRequest.SearchRequestType.CODE).map(pagingInfo -> this.searchRepositoryFiles(repoFileQuery, securityContext, (SearchPagingInfo)pagingInfo).flatMap(response -> this.buildRepositorySearchResult((SearchResponseContext)response, (SearchPagingInfo)pagingInfo, this.repoFileSearchResponseConverter))).orElse(Observable.error((Throwable)new SearchException("Search request should contain code search paging info")));
    }

    @Override
    @Nonnull
    public Observable<DetailedRepositorySearchResult> searchDetailedRepositories(@Nonnull SecurityContext securityContext, @Nonnull DetailedRepositorySearchRequest searchRequest) {
        Objects.requireNonNull(securityContext, "securityContext");
        Objects.requireNonNull(searchRequest, "searchRequest");
        if (securityContext.resolveEffectivePermissions().globalPermissionLevel() != PermissionLevel.READ) {
            throw new AuthorisationException(this.i18nService.createKeyedMessage("bitbucket.search.exception.unauthorised", new Object[0]));
        }
        return this.searchForDetailedRepositories(securityContext, searchRequest);
    }

    private long adjustTotalHitsNumber(SearchPagingInfo request, List<?> searchResult, long totalHitsNumber) {
        if (totalHitsNumber > (long)request.getPageSize()) {
            return totalHitsNumber;
        }
        return searchResult.size();
    }

    private Observable<SearchResult> buildFileSearchResult(SearchPagingInfo request, SearchResponseContext responseContext) {
        SearchResponse response = responseContext.getSearchResponse();
        if (!response.isStatusSuccess()) {
            return Observable.error((Throwable)this.getSearchException(response));
        }
        int pageNumber = request.getOffset() / request.getPageSize();
        boolean isLastPage = (long)(request.getOffset() + request.getPageSize()) >= response.getTotalHitsNumber();
        Observable<List<FileHit>> fileHitsObservable = this.fileSearchResponseConverter.convert(responseContext);
        return fileHitsObservable.map(fileHits -> ((DefaultFileSearchResult.Builder)((DefaultFileSearchResult.Builder)((DefaultFileSearchResult.Builder)((DefaultFileSearchResult.Builder)DefaultFileSearchResult.builder().fileHits((Collection<FileHit>)fileHits).totalHitCount(this.adjustTotalHitsNumber(request, (List<?>)fileHits, response.getTotalHitsNumber())).pageNumber(pageNumber)).pageSize(request.getPageSize())).offset(request.getOffset())).isLastPage(isLastPage)).build()).map(fileSearchResult -> DefaultSearchResult.builder().fileSearchResult((FileSearchResult)fileSearchResult).scope(responseContext.getScope().getResultScope()).query(responseContext.getQuery()).build());
    }

    private Observable<List<Integer>> buildRepositoryIdList(SearchResponseContext responseContext) {
        SearchResponse response = responseContext.getSearchResponse();
        if (!response.isStatusSuccess()) {
            log.debug("Non success search response code returned. Status code, {}, was returned.", (Object)response.getStatusCode());
            return Observable.just(Collections.emptyList());
        }
        return Observable.just(response.getHits().stream().flatMap(hit -> Optionals.toStream(SearchRepositoryHit.of(hit))).map(SearchRepositoryHit::getId).collect(Collectors.toList()));
    }

    private Observable<RepositorySearchResult> buildRepositorySearchResult(SearchResponseContext responseContext, SearchPagingInfo request, SearchResponseConverter<Repository> searchResponseConverter) {
        SearchResponse response = responseContext.getSearchResponse();
        if (!response.isStatusSuccess()) {
            return Observable.error((Throwable)this.getSearchException(response));
        }
        int pageNumber = request.getOffset() / request.getPageSize();
        boolean isLastPage = (long)(request.getOffset() + request.getPageSize()) >= response.getTotalHitsNumber();
        Observable<List<Repository>> repositoriesObservable = searchResponseConverter.convert(responseContext);
        return repositoriesObservable.map(repositories -> ((DefaultRepositorySearchResult.Builder)((DefaultRepositorySearchResult.Builder)((DefaultRepositorySearchResult.Builder)((DefaultRepositorySearchResult.Builder)DefaultRepositorySearchResult.builder().repositories((Collection<Repository>)repositories).totalHitCount(this.adjustTotalHitsNumber(request, (List<?>)repositories, response.getTotalHitsNumber())).pageNumber(pageNumber)).pageSize(request.getPageSize())).offset(request.getOffset())).isLastPage(isLastPage)).build());
    }

    private Observable<DetailedRepositorySearchResult> buildDetailedRepositorySearchResult(SearchResponseContext responseContext, SearchPagingInfo request, SearchResponseConverter<DetailedRepository> detailedRepoSearchResponseConverter) {
        SearchResponse response = responseContext.getSearchResponse();
        if (!response.isStatusSuccess()) {
            return Observable.error((Throwable)this.getSearchException(response));
        }
        int pageNumber = request.getOffset() / request.getPageSize();
        boolean isLastPage = (long)(request.getOffset() + request.getPageSize()) >= response.getTotalHitsNumber();
        Observable<List<DetailedRepository>> repositoriesObservable = detailedRepoSearchResponseConverter.convert(responseContext);
        return repositoriesObservable.map(repositories -> ((DefaultDetailedRepositorySearchResult.Builder)((DefaultDetailedRepositorySearchResult.Builder)((DefaultDetailedRepositorySearchResult.Builder)((DefaultDetailedRepositorySearchResult.Builder)DefaultDetailedRepositorySearchResult.builder().detailedRepositories((Collection<DetailedRepository>)repositories).totalHitCount(response.getTotalHitsNumber()).pageNumber(pageNumber)).pageSize(request.getPageSize())).offset(request.getOffset())).isLastPage(isLastPage)).build());
    }

    private Observable<SearchResponseContext> executeQuery(Either<QueryInvalidException, Query> maybeQuery, SecurityContext securityContext, SearchQueryBuilder searchQueryBuilder, Function<QueryBuilder, SearchRequestBuilder> searchRequestBuilder) {
        return (Observable)maybeQuery.fold(error -> {
            if (error instanceof QueryEmptyException) {
                return Observable.just((Object)SearchResponseContext.empty(DefaultScope.everything()));
            }
            return Observable.error((Throwable)error);
        }, query -> this.scopeResolver.resolveScope((Query)query, securityContext).flatMap(scope -> {
            if (!scope.isConsistent()) {
                return Observable.just((Object)SearchResponseContext.empty(scope));
            }
            QueryBuilder queryBuilder = searchQueryBuilder.convert((Query)query, (Scope)scope, securityContext.resolveEffectivePermissions());
            SearchRequestBuilder request = (SearchRequestBuilder)searchRequestBuilder.apply(queryBuilder);
            if (log.isDebugEnabled()) {
                log.debug("[{}] Search query: {}", (Object)securityContext.getCurrentUser().map(user -> String.valueOf(user.getId())).orElse("anonymous"), (Object)queryBuilder.build());
            }
            return this.client.execute(request).doOnNext(DefaultSearchService::traceResponse).map(rs -> SearchResponseContext.with(rs, scope, query));
        }));
    }

    @Nonnull
    private RuntimeException getSearchException(SearchResponse searchResponse) {
        return searchResponse.getErrorType().filter(ignored -> searchResponse.getStatusCode() == 400).filter("search_phase_execution_exception"::equals).map(errorType -> new QueryInvalidSearchOffsetException((String)errorType)).orElse(new UnsuccessfulResponseException((Response)searchResponse));
    }

    private Observable<SearchResponseContext> searchFiles(Either<QueryInvalidException, Query> maybeQuery, SecurityContext securityContext, SearchPagingInfo fileSearchInfo) {
        return this.executeQuery(maybeQuery, securityContext, this.fileSearchQueryBuilder, queryBuilder -> Requests.request(FileMapping.type()).search().explain(DefaultSearchService.showScoreExplanation()).source(ES.searchSource().query(queryBuilder).source(FileMapping.PATH.fieldName(), new String[]{FileMapping.PROJECT_ID.fieldName(), FileMapping.REPOSITORY_ID.fieldName()}).highlight(ES.highlight().encoder(SearchRequestHighlightBuilder.HighlightEncoder.HTML).field(HighlightFieldDefinition.builder().name(FileMapping.CONTENT.fieldName()).numberOfFragments(3).fragmentSize(1400).build()).field(HighlightFieldDefinition.builder().name(FileMapping.PATH.fieldName()).numberOfFragments(0).build()).field(HighlightFieldDefinition.builder().name(FileMapping.FILENAME.fieldName()).numberOfFragments(0).build())).page(ES.page().from(fileSearchInfo.getOffset()).size(fileSearchInfo.getPageSize()).build())));
    }

    private Observable<DetailedRepositorySearchResult> searchForDetailedRepositories(SecurityContext securityContext, DetailedRepositorySearchRequest searchRequest) {
        Either<QueryInvalidException, Query> maybeQuery = this.detailedRepositorySearchRequestParser.convertToQuery(searchRequest);
        return searchRequest.getSearchPagingInfo(SearchRequest.SearchRequestType.DETAILED_REPOSITORIES).map(repositorySearchInfo -> this.searchDetailedRepositories(maybeQuery, securityContext, (SearchPagingInfo)repositorySearchInfo, searchRequest).flatMap(response -> this.buildDetailedRepositorySearchResult((SearchResponseContext)response, (SearchPagingInfo)repositorySearchInfo, this.detailedRepoSearchResponseConverter))).orElse(Observable.error((Throwable)new IllegalArgumentException("Search request should contain repository search paging info")));
    }

    private Observable<SearchResult> searchForFiles(@Nonnull SecurityContext securityContext, @Nonnull SearchRequest searchRequest) {
        String rawSearchQuery = searchRequest.getRawSearchQuery();
        Either<QueryInvalidException, Query> maybeQuery = this.fileSearchQueryParser.parseRawQuery(rawSearchQuery);
        return searchRequest.getSearchPagingInfo(SearchRequest.SearchRequestType.CODE).map(fileSearchInfo -> this.searchFiles(maybeQuery, securityContext, (SearchPagingInfo)fileSearchInfo).flatMap(response -> {
            SearchResponse searchResponse = response.getSearchResponse();
            if (searchResponse.isStatusSuccess()) {
                this.eventPublisher.publish((Object)new CodeSearchSuccessfulEvent(this, rawSearchQuery, searchResponse.getTotalHitsNumber()));
            }
            return this.buildFileSearchResult((SearchPagingInfo)fileSearchInfo, (SearchResponseContext)response);
        })).orElse(Observable.error((Throwable)new IllegalArgumentException("Search request should contain file search paging info")));
    }

    private Observable<SearchResult> searchForRepositories(SecurityContext securityContext, SearchRequest searchRequest) {
        String rawSearchQuery = searchRequest.getRawSearchQuery();
        Either<QueryInvalidException, Query> maybeQuery = this.repositorySearchQueryParser.parseRawQuery(rawSearchQuery);
        return searchRequest.getSearchPagingInfo(SearchRequest.SearchRequestType.REPOSITORIES).map(repositorySearchInfo -> this.searchRepositories(maybeQuery, securityContext, (SearchPagingInfo)repositorySearchInfo).flatMap(response -> {
            SearchResponse searchResponse = response.getSearchResponse();
            if (searchResponse.isStatusSuccess()) {
                this.eventPublisher.publish((Object)new RepositoriesSearchSuccessfulEvent(this, rawSearchQuery, searchResponse.getTotalHitsNumber()));
            }
            return this.buildRepositorySearchResult((SearchResponseContext)response, (SearchPagingInfo)repositorySearchInfo, this.repoSearchResponseConverter).map(repositorySearchResult -> DefaultSearchResult.builder().repositorySearchResult((RepositorySearchResult)repositorySearchResult).scope(response.getScope().getResultScope()).query(response.getQuery()).build());
        })).orElse(Observable.error((Throwable)new IllegalArgumentException("Search request should contain repository search paging info")));
    }

    private Observable<SearchResponseContext> searchDetailedRepositories(Either<QueryInvalidException, Query> maybeQuery, SecurityContext securityContext, SearchPagingInfo repositorySearchInfo, DetailedRepositorySearchRequest searchRequest) {
        return this.executeQuery(maybeQuery, securityContext, this.repositorySearchQueryBuilder, queryBuilder -> {
            SearchSourceBuilder searchSourceBuilder = ES.searchSource().query(queryBuilder).page(ES.page().from(repositorySearchInfo.getOffset()).size(repositorySearchInfo.getPageSize()).build()).trackTotalHits(true);
            DetailedRepositorySortOrder detailedRepositorySortOrder = searchRequest.getDetailedRepositorySortOrder();
            switch (detailedRepositorySortOrder) {
                case RECENT_ACTIVITY_ASC: 
                case RECENT_ACTIVITY_DESC: {
                    searchSourceBuilder.sort((ContentBuilder)ES.sort((String)RepositoryMapping.RECENT_ACTIVITY.fieldName()).order(detailedRepositorySortOrder == DetailedRepositorySortOrder.RECENT_ACTIVITY_ASC ? SortBuilder.Order.ASC : SortBuilder.Order.DESC));
                    break;
                }
                case SIZE_ASC: 
                case SIZE_DESC: {
                    searchSourceBuilder.sort((ContentBuilder)ES.sort((String)RepositoryMapping.SIZE.fieldName()).order(detailedRepositorySortOrder == DetailedRepositorySortOrder.SIZE_ASC ? SortBuilder.Order.ASC : SortBuilder.Order.DESC));
                }
                case SEARCH_SCORE: {
                    searchSourceBuilder.sort((ContentBuilder)ES.sort((String)"_score").order(SortBuilder.Order.DESC));
                }
            }
            searchSourceBuilder.sort((ContentBuilder)ES.sort((String)RepositoryMapping.QUICK_SEARCH_PROJECT_NAME_RAW.fieldName()).order(SortBuilder.Order.ASC)).sort((ContentBuilder)ES.sort((String)RepositoryMapping.QUICK_SEARCH_REPOSITORY_NAME_RAW.fieldName()).order(SortBuilder.Order.ASC));
            return Requests.request(RepositoryMapping.type()).search().explain(DefaultSearchService.showScoreExplanation()).source(searchSourceBuilder);
        });
    }

    private Observable<SearchResponseContext> searchRepositories(Either<QueryInvalidException, Query> maybeQuery, SecurityContext securityContext, SearchPagingInfo repositorySearchInfo) {
        return this.executeQuery(maybeQuery, securityContext, this.repositorySearchQueryBuilder, queryBuilder -> Requests.request(RepositoryMapping.type()).search().explain(DefaultSearchService.showScoreExplanation()).source(ES.searchSource().query(queryBuilder).sort((ContentBuilder)ES.sort((String)"_score").order(SortBuilder.Order.DESC)).sort((ContentBuilder)ES.sort((String)RepositoryMapping.QUICK_SEARCH_PROJECT_NAME_RAW.fieldName()).order(SortBuilder.Order.ASC)).sort((ContentBuilder)ES.sort((String)RepositoryMapping.QUICK_SEARCH_REPOSITORY_NAME_RAW.fieldName()).order(SortBuilder.Order.ASC)).page(ES.page().from(repositorySearchInfo.getOffset()).size(repositorySearchInfo.getPageSize()).build())));
    }

    private Observable<SearchResponseContext> searchRepositoryFiles(Either<QueryInvalidException, Query> maybeQuery, SecurityContext securityContext, SearchPagingInfo fileSearchInfo) {
        return this.executeQuery(maybeQuery, securityContext, this.fileSearchQueryBuilder, queryBuilder -> Requests.request(FileMapping.type()).search().source(ES.searchSource().query(queryBuilder).source(FileMapping.PATH.fieldName(), new String[]{FileMapping.PROJECT_ID.fieldName(), FileMapping.REPOSITORY_ID.fieldName()}).page(ES.page().from(fileSearchInfo.getOffset()).size(fileSearchInfo.getPageSize()).build())));
    }
}

