/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.search;

import com.atlassian.annotations.security.AnonymousSiteAccess;
import com.atlassian.bitbucket.Product;
import com.atlassian.bitbucket.nav.NavBuilder;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import com.google.common.collect.ImmutableMap;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@AnonymousSiteAccess
@Component
public class OpenSearchServlet
extends HttpServlet {
    private final ApplicationPropertiesService applicationPropertiesService;
    private final NavBuilder navBuilder;
    private final SoyTemplateRenderer soyTemplateRenderer;

    @Autowired
    public OpenSearchServlet(NavBuilder navBuilder, SoyTemplateRenderer soyTemplateRenderer, ApplicationPropertiesService applicationPropertiesService) {
        this.navBuilder = navBuilder;
        this.soyTemplateRenderer = soyTemplateRenderer;
        this.applicationPropertiesService = applicationPropertiesService;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String name = this.applicationPropertiesService.getDisplayName();
        if (name == null) {
            name = Product.NAME;
        }
        String searchFormUrl = this.navBuilder.pluginServlets().path(new String[]{"search"}).buildAbsolute();
        ImmutableMap params = ImmutableMap.of((Object)"searchUrl", (Object)(searchFormUrl + "?q={searchTerms}"), (Object)"searchFormUrl", (Object)searchFormUrl, (Object)"name", (Object)name);
        response.setContentType("text/xml");
        this.soyTemplateRenderer.render((Appendable)response.getWriter(), "com.atlassian.bitbucket.server.bitbucket-search:opensearch-descriptor-server", "bitbucketPluginSearch.internal.feature.codesearch.opensearchDescriptor", (Map)params);
    }
}

