/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.search;

import com.atlassian.annotations.security.SystemAdminOnly;
import com.atlassian.bitbucket.dmz.discovery.DiscoverableFeature;
import com.atlassian.bitbucket.dmz.discovery.FeatureDiscoveryService;
import com.atlassian.bitbucket.internal.search.common.settings.InternalSearchSettingsService;
import com.atlassian.bitbucket.internal.search.common.settings.SearchConfigurationProperty;
import com.atlassian.bitbucket.internal.search.common.settings.SearchServerConfiguration;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionValidationService;
import com.atlassian.sal.api.websudo.WebSudoManager;
import com.atlassian.soy.renderer.SoyException;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import jakarta.annotation.Nonnull;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Map;
import java.util.Set;

@SystemAdminOnly
public class SearchAdminServlet
extends HttpServlet {
    @VisibleForTesting
    private static final String CONFIG_TEMPLATE = "bitbucketPluginSearch.internal.feature.searchAdmin.searchAdmin.searchServerConfig";
    private static final String SERVER_SOY_MODULE_KEY = "com.atlassian.bitbucket.server.bitbucket-search:search-admin-server-soy";
    private final FeatureDiscoveryService featureDiscoveryService;
    private final PermissionValidationService permissionValidationService;
    private final InternalSearchSettingsService settingsService;
    private final SoyTemplateRenderer soyTemplateRenderer;
    private final WebSudoManager webSudoManager;

    public SearchAdminServlet(FeatureDiscoveryService featureDiscoveryService, PermissionValidationService permissionValidationService, InternalSearchSettingsService settingsService, SoyTemplateRenderer soyTemplateRenderer, WebSudoManager webSudoManager) {
        this.featureDiscoveryService = featureDiscoveryService;
        this.permissionValidationService = permissionValidationService;
        this.settingsService = settingsService;
        this.soyTemplateRenderer = soyTemplateRenderer;
        this.webSudoManager = webSudoManager;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.webSudoManager.willExecuteWebSudoRequest(request);
        this.permissionValidationService.validateForGlobal(Permission.SYS_ADMIN);
        SearchServerConfiguration configuration = this.settingsService.getConfiguration(true);
        this.featureDiscoveryService.setDiscovered(Set.of(DiscoverableFeature.SEARCH_ADMIN_CONFIG));
        this.render(response, SearchAdminServlet.createParams(configuration));
    }

    private void render(HttpServletResponse response, Map<String, Object> params) throws IOException, ServletException {
        try {
            response.setContentType("text/html;charset=UTF-8");
            this.soyTemplateRenderer.render((Appendable)response.getWriter(), SERVER_SOY_MODULE_KEY, CONFIG_TEMPLATE, params);
        }
        catch (SoyException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            throw new ServletException((Throwable)e);
        }
    }

    @Nonnull
    private static Map<String, Object> createParams(SearchServerConfiguration configuration) {
        return Map.of("config", Map.of("awsRegion", SearchAdminServlet.createPropertyObject(configuration.getAwsRegion()), "url", SearchAdminServlet.createPropertyObject(configuration.getBaseUrl()), "password", SearchAdminServlet.createPropertyObject(configuration.getPassword()), "username", SearchAdminServlet.createPropertyObject(configuration.getUsername())));
    }

    @Nonnull
    private static Map<String, String> createPropertyObject(SearchConfigurationProperty setting) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        setting.getValue().ifPresent(value -> builder.put((Object)"value", value));
        setting.getConfiguredAt().ifPresent(configuredAt -> builder.put((Object)"configuredAt", (Object)configuredAt.name()));
        return builder.build();
    }
}

