/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.search;

import com.atlassian.annotations.security.LicensedOnly;
import com.atlassian.bitbucket.dmz.discovery.DiscoverableFeature;
import com.atlassian.bitbucket.dmz.discovery.FeatureDiscoveryService;
import com.atlassian.bitbucket.internal.search.common.settings.SearchSettingsAccessor;
import com.atlassian.bitbucket.internal.search.common.settings.tester.SearchConnectionResult;
import com.atlassian.bitbucket.internal.search.common.settings.tester.SearchConnectionTester;
import com.atlassian.bitbucket.internal.search.indexing.monitoring.repository.RepositoryIndexingDetailsService;
import com.atlassian.bitbucket.internal.search.indexing.rest.RestRepositoryIndexingDetails;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionService;
import com.atlassian.bitbucket.permission.PermissionValidationService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositorySupplier;
import com.atlassian.bitbucket.scope.RepositoryScope;
import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.bitbucket.scope.ScopeVisitor;
import com.atlassian.bitbucket.scope.Scopes;
import com.atlassian.soy.renderer.SoyException;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import jakarta.annotation.Nonnull;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Optional;

@LicensedOnly
public class SearchIndexingServlet
extends HttpServlet {
    @VisibleForTesting
    static final String RESOURCE_KEY = "com.atlassian.bitbucket.server.bitbucket-search:search-indexing-soy";
    @VisibleForTesting
    static final String TEMPLATE_KEY = "bitbucketPluginSearch.internal.feature.repository.search.indexing.page";
    private final FeatureDiscoveryService featureDiscoveryService;
    private final PermissionService permissionService;
    private final PermissionValidationService permissionValidationService;
    private final RepositoryIndexingDetailsService repositoryIndexingDetailsService;
    private final RepositorySupplier repositorySupplier;
    private final SearchConnectionTester searchConnectionTester;
    private final SearchSettingsAccessor searchSettingsAccessor;
    private final SoyTemplateRenderer soyTemplateRenderer;

    public SearchIndexingServlet(FeatureDiscoveryService featureDiscoveryService, PermissionService permissionService, PermissionValidationService permissionValidationService, RepositoryIndexingDetailsService repositoryIndexingDetailsService, RepositorySupplier repositorySupplier, SearchConnectionTester searchConnectionTester, SearchSettingsAccessor searchSettingsAccessor, SoyTemplateRenderer soyTemplateRenderer) {
        this.featureDiscoveryService = featureDiscoveryService;
        this.permissionService = permissionService;
        this.permissionValidationService = permissionValidationService;
        this.repositoryIndexingDetailsService = repositoryIndexingDetailsService;
        this.repositorySupplier = repositorySupplier;
        this.searchConnectionTester = searchConnectionTester;
        this.searchSettingsAccessor = searchSettingsAccessor;
        this.soyTemplateRenderer = soyTemplateRenderer;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Optional<Scope> scope = this.getScope(req.getPathInfo());
        if (!scope.isPresent() || !(scope.get() instanceof RepositoryScope)) {
            resp.sendError(404);
            return;
        }
        final HashMap context = new HashMap();
        scope.get().accept((ScopeVisitor)new ScopeVisitor<Void>(){

            public Void visit(@Nonnull RepositoryScope scope) {
                Repository repository = scope.getRepository();
                SearchIndexingServlet.this.permissionValidationService.validateForRepository(repository, Permission.REPO_ADMIN);
                String userRole = String.valueOf(Permission.REPO_ADMIN);
                if (SearchIndexingServlet.this.permissionService.hasGlobalPermission(Permission.SYS_ADMIN)) {
                    userRole = String.valueOf(Permission.SYS_ADMIN);
                } else if (SearchIndexingServlet.this.permissionService.hasProjectPermission(scope.getProject(), Permission.PROJECT_ADMIN)) {
                    userRole = String.valueOf(Permission.PROJECT_ADMIN);
                }
                context.put("project", scope.getProject());
                context.put("repository", scope.getRepository());
                context.put("scopeType", scope.getType());
                context.put("userRole", userRole);
                SearchConnectionResult searchConnectionResult = SearchIndexingServlet.this.searchConnectionTester.testConnection(SearchIndexingServlet.this.searchSettingsAccessor);
                boolean searchServerAvailable = searchConnectionResult == SearchConnectionResult.SUCCESS;
                context.put("searchServerAvailable", searchServerAvailable);
                if (searchServerAvailable) {
                    context.put("indexingDetails", new RestRepositoryIndexingDetails(SearchIndexingServlet.this.repositoryIndexingDetailsService.getIndexingDetails(scope.getRepository())));
                }
                return null;
            }
        });
        try {
            resp.setContentType("text/html;charset=UTF-8");
            this.featureDiscoveryService.setDiscovered(EnumSet.of(DiscoverableFeature.SEARCH_INDEXING));
            this.soyTemplateRenderer.render((Appendable)resp.getWriter(), RESOURCE_KEY, TEMPLATE_KEY, context);
        }
        catch (SoyException soyException) {
            this.handleSoyError(soyException);
        }
    }

    private Optional<Scope> getScope(String pathInfo) {
        if (Strings.isNullOrEmpty((String)pathInfo)) {
            return Optional.empty();
        }
        String[] pathParts = pathInfo.substring(1).split("/");
        if (pathParts.length < 2) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.repositorySupplier.getBySlug(pathParts[0], pathParts[1])).map(Scopes::repository);
    }

    private void handleSoyError(SoyException e) throws IOException, ServletException {
        Throwable cause = e.getCause();
        if (cause instanceof IOException) {
            throw (IOException)cause;
        }
        throw new ServletException((Throwable)e);
    }
}

