/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.search;

import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import java.time.Duration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SearchProperties {
    static final String SEARCH_HTTP_CONNECTION_POOL_TIMEOUT_KEY = "plugin.search.search.connection.pool.timeout";
    static final String SEARCH_HTTP_CONNECTION_TIMEOUT_KEY = "plugin.search.search.http.connection.timeout";
    static final String SEARCH_HTTP_KEEP_ALIVE_IDLE_TIMEOUT_KEY = "plugin.search.search.http.keepalive.idle.timeout";
    static final String SEARCH_HTTP_SOCKET_TIMEOUT_KEY = "plugin.search.search.http.socket.timeout";
    private static final Duration DEFAULT_SEARCH_HTTP_CLIENT_KEEP_ALIVE_IDLE_TIMEOUT = Duration.ofMinutes(30L);
    private static final Duration DEFAULT_SEARCH_HTTP_CONNECTION_POOL_TIMEOUT = Duration.ofSeconds(1L);
    private static final Duration DEFAULT_SEARCH_HTTP_CONNECTION_TIMEOUT = Duration.ofSeconds(6L);
    private static final Duration DEFAULT_SEARCH_HTTP_SOCKET_TIMEOUT = Duration.ofSeconds(5L);
    private final ApplicationPropertiesService applicationPropertiesService;

    @Autowired
    public SearchProperties(ApplicationPropertiesService applicationPropertiesService) {
        this.applicationPropertiesService = applicationPropertiesService;
    }

    public Duration getHttpConnectionPoolTimeout() {
        return this.getDurationOrDefault(SEARCH_HTTP_CONNECTION_POOL_TIMEOUT_KEY, DEFAULT_SEARCH_HTTP_CONNECTION_POOL_TIMEOUT);
    }

    public Duration getHttpConnectionTimeout() {
        return this.getDurationOrDefault(SEARCH_HTTP_CONNECTION_TIMEOUT_KEY, DEFAULT_SEARCH_HTTP_CONNECTION_TIMEOUT);
    }

    public Duration getHttpKeepAliveIdleTimeout() {
        return this.getDurationOrDefault(SEARCH_HTTP_KEEP_ALIVE_IDLE_TIMEOUT_KEY, DEFAULT_SEARCH_HTTP_CLIENT_KEEP_ALIVE_IDLE_TIMEOUT);
    }

    public Duration getHttpSocketTimeout() {
        return this.getDurationOrDefault(SEARCH_HTTP_SOCKET_TIMEOUT_KEY, DEFAULT_SEARCH_HTTP_SOCKET_TIMEOUT);
    }

    private Duration getDurationOrDefault(String pluginPropertyKey, Duration defaultDuration) {
        long timeout = this.applicationPropertiesService.getPluginProperty(pluginPropertyKey, 0L);
        if (timeout > 0L) {
            return Duration.ofSeconds(timeout);
        }
        return defaultDuration;
    }
}

