/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.search;

import com.atlassian.bitbucket.internal.search.search.query.Query;
import com.atlassian.bitbucket.internal.search.search.scope.Scope;
import com.atlassian.elasticsearch.client.ES;
import com.atlassian.elasticsearch.client.content.ContentBuilder;
import com.atlassian.elasticsearch.client.search.SearchResponse;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;
import java.util.Optional;

public class SearchResponseContext {
    private final Query query;
    private final Scope scope;
    private final SearchResponse searchResponse;

    private SearchResponseContext(@Nonnull SearchResponse searchResponse, @Nonnull Scope scope, @Nullable Query query) {
        this.searchResponse = Objects.requireNonNull(searchResponse, "searchResponse");
        this.scope = Objects.requireNonNull(scope, "scope");
        this.query = query;
    }

    public static SearchResponseContext empty(@Nonnull Scope scope) {
        return new SearchResponseContext(SearchResponse.builder().statusCode(204).content(ES.objectContent().with("hits", (ContentBuilder)ES.objectContent().with("total", (Number)0)).build()).build(), scope, null);
    }

    public static SearchResponseContext with(@Nonnull SearchResponse searchResponse, @Nonnull Scope scope, @Nullable Query query) {
        return new SearchResponseContext(searchResponse, scope, query);
    }

    public Optional<Query> getQuery() {
        return Optional.ofNullable(this.query);
    }

    @Nonnull
    public Scope getScope() {
        return this.scope;
    }

    @Nonnull
    public SearchResponse getSearchResponse() {
        return this.searchResponse;
    }
}

