/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.search;

import com.atlassian.annotations.security.AnonymousSiteAccess;
import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.server.Feature;
import com.atlassian.bitbucket.server.FeatureManager;
import com.atlassian.bitbucket.server.StandardFeature;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.URI;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@AnonymousSiteAccess
@Component
public class SearchServlet
extends HttpServlet {
    private final AuthenticationContext authenticationContext;
    private final FeatureManager featureManager;
    private final LoginUriProvider loginUriProvider;
    private final SoyTemplateRenderer soyTemplateRenderer;

    @Autowired
    public SearchServlet(SoyTemplateRenderer soyTemplateRenderer, FeatureManager featureManager, LoginUriProvider loginUriProvider, AuthenticationContext authenticationContext) {
        this.soyTemplateRenderer = soyTemplateRenderer;
        this.featureManager = featureManager;
        this.loginUriProvider = loginUriProvider;
        this.authenticationContext = authenticationContext;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (!this.authenticationContext.isAuthenticated() && !this.featureManager.isEnabled((Feature)StandardFeature.PUBLIC_ACCESS)) {
            String contextPath;
            Object requestUri = request.getRequestURI();
            String queryString = request.getQueryString();
            if (!Strings.isNullOrEmpty((String)queryString)) {
                requestUri = (String)requestUri + "?" + queryString;
            }
            if (!Strings.isNullOrEmpty((String)(contextPath = request.getContextPath()))) {
                requestUri = ((String)requestUri).substring(contextPath.length());
            }
            response.sendRedirect(this.loginUriProvider.getLoginUri(URI.create((String)requestUri)).toString());
            return;
        }
        String query = request.getParameter("q");
        if (query == null) {
            query = "";
        }
        ImmutableMap params = ImmutableMap.of((Object)"query", (Object)query);
        response.setContentType("text/html;charset=UTF-8");
        this.soyTemplateRenderer.render((Appendable)response.getWriter(), "com.atlassian.bitbucket.server.bitbucket-search:code-search-server", "bitbucketPluginSearch.internal.component.searchPage.searchPageServer.page", (Map)params);
    }
}

