/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.search.client;

import com.atlassian.bitbucket.event.cluster.ClusterNodeAddedEvent;
import com.atlassian.bitbucket.internal.search.client.ConfigurableSearchClient;
import com.atlassian.bitbucket.internal.search.common.clientutil.SearchClientFactory;
import com.atlassian.bitbucket.internal.search.common.clientutil.SearchClientSettings;
import com.atlassian.bitbucket.internal.search.common.settings.SearchConfigurationChangedMessage;
import com.atlassian.bitbucket.internal.search.common.settings.SearchSettingsAccessor;
import com.atlassian.bitbucket.internal.search.common.settings.UsernamePassword;
import com.atlassian.bitbucket.internal.search.search.SearchProperties;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.topic.MessageEvent;
import com.atlassian.bitbucket.topic.TopicListener;
import com.atlassian.bitbucket.topic.TopicService;
import com.atlassian.bitbucket.topic.TopicSettings;
import com.atlassian.bitbucket.user.EscalatedSecurityContext;
import com.atlassian.bitbucket.user.SecurityService;
import com.atlassian.elasticsearch.client.Client;
import com.atlassian.event.api.EventListener;
import com.atlassian.sal.api.lifecycle.LifecycleAware;
import com.codahale.metrics.MetricRegistry;
import jakarta.annotation.Nonnull;
import java.time.Duration;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="searchClientLifecycleManager")
public class SearchClientLifecycleManager
implements LifecycleAware,
SearchClientSettings,
TopicListener<SearchConfigurationChangedMessage> {
    private static final int MAX_POOL_CONNECTIONS = 20;
    private static final Logger log = LoggerFactory.getLogger(SearchClientLifecycleManager.class);
    private final ConfigurableSearchClient configurableSearchClient;
    private final MetricRegistry metricRegistry;
    private final SearchProperties searchProperties;
    private final SearchSettingsAccessor searchSettingsAccessor;
    private final TopicService topicService;
    private final SearchClientFactory searchClientFactory;
    private final EscalatedSecurityContext withSysAdmin;
    private String subscriptionId;

    @Autowired
    public SearchClientLifecycleManager(ConfigurableSearchClient configurableSearchClient, SearchClientFactory searchClientFactory, MetricRegistry metricRegistry, SearchProperties searchProperties, SearchSettingsAccessor searchSettingsAccessor, SecurityService securityService, TopicService topicService) {
        this.configurableSearchClient = configurableSearchClient;
        this.searchClientFactory = searchClientFactory;
        this.searchProperties = searchProperties;
        this.metricRegistry = metricRegistry;
        this.searchSettingsAccessor = searchSettingsAccessor;
        this.topicService = topicService;
        this.subscriptionId = null;
        this.withSysAdmin = securityService.withPermission(Permission.SYS_ADMIN, "Create search client");
    }

    @Override
    public Optional<String> getAwsRegion() {
        return this.searchSettingsAccessor.getAwsRegion();
    }

    @Override
    public String getBaseUrl() {
        return this.searchSettingsAccessor.getBaseUrl();
    }

    @Override
    public Duration getHttpConnectionPoolTimeout() {
        return this.searchProperties.getHttpConnectionPoolTimeout();
    }

    @Override
    public Duration getHttpConnectionTimeout() {
        return this.searchProperties.getHttpConnectionTimeout();
    }

    @Override
    public Duration getHttpKeepAliveIdleTimeout() {
        return this.searchProperties.getHttpKeepAliveIdleTimeout();
    }

    @Override
    public Duration getHttpSocketTimeout() {
        return this.searchProperties.getHttpSocketTimeout();
    }

    @Override
    public int getMaxPoolConnections() {
        return 20;
    }

    @Override
    public Optional<UsernamePassword> getUsernamePassword() {
        return this.searchSettingsAccessor.getUsernamePassword();
    }

    @EventListener
    public void onClusterNodeAddedEvent(ClusterNodeAddedEvent event) {
        this.refreshClient();
    }

    public void onMessage(@Nonnull MessageEvent<SearchConfigurationChangedMessage> message) {
        log.debug("Received search server configuration changed event");
        this.refreshClient();
    }

    public void onStart() {
        this.subscriptionId = this.topicService.getTopic("search:config.changed", TopicSettings.builder(SearchConfigurationChangedMessage.class).build()).subscribe((TopicListener)this);
        this.refreshClient();
    }

    public void onStop() {
        if (this.subscriptionId != null) {
            this.topicService.getTopic("search:config.changed", TopicSettings.builder(SearchConfigurationChangedMessage.class).build()).unsubscribe(this.subscriptionId);
        }
        this.configurableSearchClient.close();
    }

    private void refreshClient() {
        this.configurableSearchClient.replaceClient((Client)this.withSysAdmin.call(() -> this.searchClientFactory.create(this, this.metricRegistry)));
    }
}

