/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.search.convert;

import com.atlassian.bitbucket.AuthorisationException;
import com.atlassian.bitbucket.dmz.repositorymanagement.DmzRepositoryManagementService;
import com.atlassian.bitbucket.internal.search.common.mapping.RepositoryMapping;
import com.atlassian.bitbucket.internal.search.search.DetailedRepository;
import com.atlassian.bitbucket.internal.search.search.SearchResponseContext;
import com.atlassian.bitbucket.internal.search.search.convert.SearchResponseConverter;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.elasticsearch.client.search.Hit;
import com.atlassian.elasticsearch.client.search.SearchResponse;
import jakarta.annotation.Nonnull;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import rx.Observable;

@Component(value="detailedRepoSearchResponseConverter")
public class DetailedRepositorySearchResponseConverter
implements SearchResponseConverter<DetailedRepository> {
    private static final Logger log = LoggerFactory.getLogger(DetailedRepositorySearchResponseConverter.class);
    private final DmzRepositoryManagementService repositoryManagementService;
    private final RepositoryService repositoryService;

    @Autowired
    public DetailedRepositorySearchResponseConverter(DmzRepositoryManagementService repositoryManagementService, RepositoryService repositoryService) {
        this.repositoryManagementService = repositoryManagementService;
        this.repositoryService = repositoryService;
    }

    @Override
    @Nonnull
    public Observable<List<DetailedRepository>> convert(@Nonnull SearchResponseContext searchResponse) {
        SearchResponse response = Objects.requireNonNull(searchResponse, "searchResponse").getSearchResponse();
        Map repositories = (Map)response.getHits().stream().map(hit -> {
            int repoId = Integer.parseInt(hit.getId());
            try {
                return this.repositoryService.getById(repoId);
            }
            catch (AuthorisationException e) {
                log.debug("User is not authorised to access repository {}", (Object)repoId, (Object)e);
                return null;
            }
        }).filter(Objects::nonNull).collect(MoreCollectors.toImmutableMap(Repository::getId, Function.identity()));
        Set hierarchyIds = (Set)repositories.values().stream().map(Repository::getHierarchyId).collect(MoreCollectors.toImmutableSet());
        Map hierarchyCount = this.repositoryManagementService.countByHierarchies(hierarchyIds);
        List detailedRepositories = (List)response.getHits().stream().map(hit -> DetailedRepositorySearchResponseConverter.createDetailedRepositoryHit(repositories, hierarchyCount, hit)).filter(Objects::nonNull).map(DetailedRepositoryHit::toDetailedRepository).collect(MoreCollectors.toImmutableList());
        return Observable.just((Object)detailedRepositories);
    }

    private static DetailedRepositoryHit createDetailedRepositoryHit(Map<Integer, Repository> repositories, Map<String, Long> hierarchyCount, Hit hit) {
        Repository repository = repositories.get(Integer.parseInt(hit.getId()));
        if (repository == null) {
            return null;
        }
        long hierarchyId = hierarchyCount.getOrDefault(repository.getHierarchyId(), 1L);
        Date recentActivity = hit.getSource().flatMap(source -> source.getNumber(RepositoryMapping.RECENT_ACTIVITY.fieldName()).map(n -> new Date(n.longValue()))).orElse(null);
        Long size = hit.getSource().flatMap(source -> source.getNumber(RepositoryMapping.SIZE.fieldName()).map(Number::longValue)).orElse(null);
        return new DetailedRepositoryHit(repository, hierarchyId, recentActivity, size);
    }

    private static final class DetailedRepositoryHit {
        private final long numRepositoriesInHierarchy;
        private final Date recentActivity;
        private final Repository repository;
        private final Long size;

        private DetailedRepositoryHit(@Nonnull Repository repository, long numRepositoriesInHierarchy, Date recentActivity, Long size) {
            this.repository = repository;
            this.numRepositoriesInHierarchy = numRepositoriesInHierarchy;
            this.recentActivity = recentActivity;
            this.size = size;
        }

        public DetailedRepository toDetailedRepository() {
            return new DetailedRepository(this.repository, this.numRepositoriesInHierarchy, this.recentActivity, this.size);
        }
    }
}

