/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.search.convert;

import com.atlassian.bitbucket.AuthorisationException;
import com.atlassian.bitbucket.internal.search.client.SearchClient;
import com.atlassian.bitbucket.internal.search.search.SearchResponseContext;
import com.atlassian.bitbucket.internal.search.search.convert.SearchFileHit;
import com.atlassian.bitbucket.internal.search.search.convert.SearchResponseConverter;
import com.atlassian.bitbucket.internal.search.search.result.FileHit;
import com.atlassian.bitbucket.internal.search.search.scope.Scope;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.elasticsearch.client.search.SearchResponse;
import jakarta.annotation.Nonnull;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import rx.Observable;

@Component(value="fileSearchResponseConverter")
public class FileSearchResponseConverter
implements SearchResponseConverter<FileHit> {
    private static final Logger log = LoggerFactory.getLogger(FileSearchResponseConverter.class);
    private final SearchClient client;
    private final RepositoryService repositoryService;

    @Autowired
    public FileSearchResponseConverter(SearchClient client, RepositoryService repositoryService) {
        this.client = client;
        this.repositoryService = repositoryService;
    }

    @Override
    @Nonnull
    public Observable<List<FileHit>> convert(@Nonnull SearchResponseContext searchResponse) {
        SearchResponse response = Objects.requireNonNull(searchResponse, "searchResponse").getSearchResponse();
        List<SearchFileHit> searchFileHits = response.getHits().stream().map(SearchFileHit::of).collect(Collectors.toList());
        Observable<Map<Integer, Repository>> repositoriesObservable = this.getRepositoriesFor(searchFileHits, searchResponse.getScope());
        return repositoriesObservable.map(repositories -> searchFileHits.stream().flatMap(hit -> Optional.ofNullable((Repository)repositories.get(hit.getRepositoryId())).map(repo -> Stream.of(hit.toFileHit((Repository)repo))).orElse(Stream.empty())).collect(Collectors.toList()));
    }

    private static Collector<Repository, ?, Map<Integer, Repository>> toRepositoryMap() {
        return Collectors.toMap(Repository::getId, Function.identity());
    }

    private Observable<Map<Integer, Repository>> getRepositoriesFor(List<SearchFileHit> searchFileHits, Scope scope) {
        if (searchFileHits.isEmpty()) {
            return Observable.just(Collections.emptyMap());
        }
        Collection<Repository> scopeRepositories = scope.getRepositories();
        if (!scopeRepositories.isEmpty()) {
            return Observable.just(scopeRepositories.stream().collect(FileSearchResponseConverter.toRepositoryMap()));
        }
        return Observable.just(searchFileHits.stream().mapToInt(SearchFileHit::getRepositoryId).distinct().mapToObj(repoId -> {
            try {
                return this.repositoryService.getById(repoId);
            }
            catch (AuthorisationException e) {
                log.debug("User is not authorised to access repository {}", (Object)repoId, (Object)e);
                return null;
            }
        }).filter(Objects::nonNull).collect(FileSearchResponseConverter.toRepositoryMap()));
    }
}

