/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.search.convert;

import com.atlassian.bitbucket.internal.search.search.result.DefaultHitContext;
import com.atlassian.bitbucket.internal.search.search.result.HitContext;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.primitives.Ints;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.util.StringUtils;

public class HighlightedContentToHitContextFunction
implements Function<String, HitContext> {
    @VisibleForTesting
    static final int CONTEXT_LINES = 1;
    private static final Pattern LINE_NUMBER_CONTENT_PATTERN = Pattern.compile("^(?:(\\d+) )?(.*)");
    private static final Pattern LINE_SEPARATOR_PATTERN = Pattern.compile("\r\n|[\n\r\u2028\u2029\u0085]");

    @Override
    public HitContext apply(String s) {
        if (s == null || s.isEmpty()) {
            return DefaultHitContext.EMPTY;
        }
        ArrayList<String> contents = new ArrayList<String>();
        int firstLineNumber = 0;
        int firstHighlightIndex = -1;
        int lastHighlightIndex = -1;
        int hits = 0;
        Iterator lineIterator = LINE_SEPARATOR_PATTERN.splitAsStream(s).iterator();
        int i = 0;
        while (lineIterator.hasNext()) {
            Integer lineNumber;
            String lineNumberGroup;
            String line = (String)lineIterator.next();
            Matcher matcher = LINE_NUMBER_CONTENT_PATTERN.matcher(line);
            if (!matcher.matches()) {
                throw new IllegalStateException("Pattern should always match (line number is optional)");
            }
            if (i != 0 && !lineIterator.hasNext() && HighlightedContentToHitContextFunction.getLineNumber(matcher) == null) break;
            String content = HighlightedContentToHitContextFunction.getContent(matcher);
            contents.add(content);
            if (i == 0 && line.length() <= 1400 && !lineIterator.hasNext()) {
                lineNumberGroup = HighlightedContentToHitContextFunction.getLineNumber(matcher);
                if (lineNumberGroup != null && (lineNumber = Ints.tryParse((String)lineNumberGroup)) != null && lineNumber.equals(1)) {
                    firstLineNumber = 1;
                }
            } else if (i > 0 && firstLineNumber == 0 && (lineNumberGroup = HighlightedContentToHitContextFunction.getLineNumber(matcher)) != null && (lineNumber = Ints.tryParse((String)lineNumberGroup)) != null) {
                firstLineNumber = lineNumber - i;
            }
            if (content.contains("<em>")) {
                if (firstHighlightIndex == -1) {
                    firstHighlightIndex = i;
                }
                lastHighlightIndex = i;
                hits += StringUtils.countOccurrencesOf((String)content, (String)"<em>");
            }
            ++i;
        }
        int fromIndex = Integer.max(firstHighlightIndex - 1, 0);
        int toIndexExclusive = Integer.min(lastHighlightIndex + 1 + 1, contents.size());
        List<String> result = contents.subList(fromIndex, toIndexExclusive);
        int firstResultLineNumber = firstLineNumber + fromIndex;
        return DefaultHitContext.builder().lines(result).hitCount(hits).firstLineNumber(firstResultLineNumber).build();
    }

    private static String getContent(Matcher matcher) {
        return matcher.group(2);
    }

    private static String getLineNumber(Matcher matcher) {
        return matcher.group(1);
    }
}

