/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.search.convert;

import com.atlassian.bitbucket.internal.search.common.util.Filenames;
import com.atlassian.bitbucket.internal.search.search.result.DefaultSegment;
import com.atlassian.bitbucket.internal.search.search.result.Segment;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringEscapeUtils;

public class HighlightedPathConverter {
    public static List<Segment> convert(String path, Optional<String> pathFragment, Optional<String> filenameFragment) {
        List<Segment> pathSegments = HighlightedPathConverter.parseFragment(pathFragment);
        List<Segment> filenameSegments = HighlightedPathConverter.parseFragment(filenameFragment);
        if (pathSegments.isEmpty() && filenameSegments.isEmpty()) {
            return Collections.emptyList();
        }
        if (filenameSegments.isEmpty()) {
            return pathSegments;
        }
        if (pathSegments.isEmpty()) {
            return HighlightedPathConverter.mergeFilenameSegments(path, filenameSegments);
        }
        return HighlightedPathConverter.mergePathAndFilenameSegments(path, pathSegments, filenameSegments);
    }

    private static List<Segment> mergeFilenameSegments(String path, List<Segment> filenameSegments) {
        ImmutableList.Builder mergedSegments = ImmutableList.builder();
        Optional<String> parent = Filenames.getParent(path);
        parent.ifPresent(p -> {
            DefaultSegment parentSegment = DefaultSegment.builder().text(p + "/").build();
            mergedSegments.add((Object)parentSegment);
        });
        mergedSegments.addAll(filenameSegments);
        return mergedSegments.build();
    }

    private static List<Segment> mergePathAndFilenameSegments(String path, List<Segment> pathSegments, List<Segment> filenameSegments) {
        Segment lastPathSegment = pathSegments.get(pathSegments.size() - 1);
        if (lastPathSegment.isMatching() && lastPathSegment.getText().equals(Filenames.getFilename(path))) {
            return pathSegments;
        }
        List<Segment> initialPathSegments = pathSegments.subList(0, pathSegments.size() - 1);
        ImmutableList.Builder mergedSegments = ImmutableList.builder();
        mergedSegments.addAll(initialPathSegments);
        Optional<String> parent = Filenames.getParent(lastPathSegment.getText());
        parent.ifPresent(p -> mergedSegments.add((Object)DefaultSegment.builder().text(p + "/").build()));
        mergedSegments.addAll(filenameSegments);
        return mergedSegments.build();
    }

    private static List<Segment> parseFragment(Optional<String> fragment) {
        if (!fragment.isPresent()) {
            return Collections.emptyList();
        }
        ArrayList<Segment> segments = new ArrayList<Segment>();
        String s = fragment.get();
        int start = 0;
        while (start < s.length()) {
            int em = s.indexOf("<em>", start);
            if (em != -1) {
                if (start < em) {
                    segments.add(HighlightedPathConverter.nonMatching(s.substring(start, em)));
                }
                int startOfMatch = em + "<em>".length();
                int endOfMatch = s.indexOf("</em>", startOfMatch);
                segments.add(HighlightedPathConverter.matching(s.substring(startOfMatch, endOfMatch)));
                start = endOfMatch + "</em>".length();
                continue;
            }
            segments.add(HighlightedPathConverter.nonMatching(s.substring(start)));
            start = s.length();
        }
        return segments;
    }

    private static Segment matching(String s) {
        return DefaultSegment.matching(HighlightedPathConverter.unescape(s));
    }

    private static Segment nonMatching(String s) {
        return DefaultSegment.nonMatching(HighlightedPathConverter.unescape(s));
    }

    private static String unescape(String s) {
        return StringEscapeUtils.unescapeHtml4((String)s);
    }
}

