/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.search.convert;

import com.atlassian.bitbucket.AuthorisationException;
import com.atlassian.bitbucket.internal.search.search.SearchResponseContext;
import com.atlassian.bitbucket.internal.search.search.convert.SearchFileHit;
import com.atlassian.bitbucket.internal.search.search.convert.SearchResponseConverter;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.elasticsearch.client.search.SearchResponse;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import rx.Observable;

@Component(value="repoFileSearchResponseConverter")
public class RepositoryFileSearchResponseConverter
implements SearchResponseConverter<Repository> {
    private static final Logger log = LoggerFactory.getLogger(RepositoryFileSearchResponseConverter.class);
    private final RepositoryService repositoryService;

    @Autowired
    public RepositoryFileSearchResponseConverter(RepositoryService repositoryService) {
        this.repositoryService = repositoryService;
    }

    @Override
    @Nonnull
    public Observable<List<Repository>> convert(@Nonnull SearchResponseContext searchResponseContext) {
        SearchResponse response = Objects.requireNonNull(searchResponseContext, "searchResponseContext").getSearchResponse();
        return Observable.just(response.getHits().stream().map(SearchFileHit::of).filter(file -> !file.getPath().contains("/")).map(SearchFileHit::getRepositoryId).distinct().map(repoId -> {
            try {
                return this.repositoryService.getById(repoId.intValue());
            }
            catch (AuthorisationException e) {
                log.debug("User is not authorised to access repository {}", repoId, (Object)e);
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList()));
    }
}

