/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.search.convert;

import com.atlassian.bitbucket.internal.search.common.util.Optionals;
import com.atlassian.bitbucket.internal.search.search.SearchResponseContext;
import com.atlassian.bitbucket.internal.search.search.convert.SearchRepositoryHit;
import com.atlassian.bitbucket.internal.search.search.convert.SearchResponseConverter;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.elasticsearch.client.search.SearchResponse;
import jakarta.annotation.Nonnull;
import java.text.Collator;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import rx.Observable;

@Component(value="repoSearchResponseConverter")
public class RepositorySearchResponseConverter
implements SearchResponseConverter<Repository> {
    private static final Collator COLLATOR = Collator.getInstance(Locale.ENGLISH);
    private final RepositoryService repositoryService;

    @Autowired
    public RepositorySearchResponseConverter(RepositoryService repositoryService) {
        this.repositoryService = repositoryService;
    }

    @Override
    @Nonnull
    public Observable<List<Repository>> convert(@Nonnull SearchResponseContext searchResponse) {
        SearchResponse response = Objects.requireNonNull(searchResponse, "searchResponse").getSearchResponse();
        return Observable.just(response.getHits().stream().flatMap(hit -> Optionals.toStream(SearchRepositoryHit.of(hit))).map(esRepositoryHit -> new RepositoryWithScore(this.repositoryService.getById(esRepositoryHit.getId()), esRepositoryHit.getScore())).filter(repositoryWithScore -> repositoryWithScore.getRepository() != null).sorted(Comparator.comparing(RepositoryWithScore::getScore).reversed().thenComparing(rp -> COLLATOR.getCollationKey(rp.getRepository().getProject().getName())).thenComparing(rp -> COLLATOR.getCollationKey(rp.getRepository().getName()))).map(RepositoryWithScore::getRepository).collect(Collectors.toList()));
    }

    private static class RepositoryWithScore {
        private final Repository repository;
        private final double score;

        private RepositoryWithScore(Repository repository, double score) {
            this.repository = repository;
            this.score = score;
        }

        public Repository getRepository() {
            return this.repository;
        }

        public double getScore() {
            return this.score;
        }
    }
}

