/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.search.convert;

import com.atlassian.bitbucket.internal.search.common.mapping.FileMapping;
import com.atlassian.bitbucket.internal.search.search.convert.HighlightedContentToHitContextFunction;
import com.atlassian.bitbucket.internal.search.search.convert.HighlightedPathConverter;
import com.atlassian.bitbucket.internal.search.search.result.DefaultFileHit;
import com.atlassian.bitbucket.internal.search.search.result.FileHit;
import com.atlassian.bitbucket.internal.search.search.result.HitContext;
import com.atlassian.bitbucket.internal.search.search.result.Segment;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.elasticsearch.client.content.Content;
import com.atlassian.elasticsearch.client.content.ContentVisitor;
import com.atlassian.elasticsearch.client.content.ContentVisitors;
import com.atlassian.elasticsearch.client.content.ObjectContent;
import com.atlassian.elasticsearch.client.search.Hit;
import jakarta.annotation.Nonnull;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public class SearchFileHit {
    private final ObjectContent highlight;
    private final String path;
    private final int projectId;
    private final int repositoryId;

    private SearchFileHit(String path, int projectId, int repositoryId, ObjectContent highlight) {
        this.path = path;
        this.projectId = projectId;
        this.repositoryId = repositoryId;
        this.highlight = highlight;
    }

    public static SearchFileHit of(Hit hit) {
        ObjectContent source = (ObjectContent)hit.getSource().orElseThrow(() -> new IllegalStateException("File hit does not have a source"));
        String path = source.getStringOrThrow(FileMapping.PATH.fieldName());
        Number repoId = source.getNumberOrThrow(FileMapping.REPOSITORY_ID.fieldName());
        Number projectId = source.getNumberOrThrow(FileMapping.PROJECT_ID.fieldName());
        return new SearchFileHit(path, projectId.intValue(), repoId.intValue(), hit.getHighlight().orElse(null));
    }

    public String getPath() {
        return this.path;
    }

    public int getProjectId() {
        return this.projectId;
    }

    public int getRepositoryId() {
        return this.repositoryId;
    }

    FileHit toFileHit(Repository repository) {
        List<HitContext> hitContexts = this.extractHitContexts();
        List<Segment> pathMatches = this.extractPathMatches();
        return DefaultFileHit.builder().path(this.path).pathMatches(pathMatches).repository(repository).hitContexts(hitContexts).build();
    }

    private List<HitContext> extractHitContexts() {
        return Optional.ofNullable(this.highlight).map(objectContent -> (Excerpts)objectContent.accept((ContentVisitor)FileHitHighlightVisitor.instance)).flatMap(excerpts -> excerpts.forContentField().map(highlight -> highlight.content)).orElseGet(Collections::emptyList);
    }

    private List<Segment> extractPathMatches() {
        Optional<String> pathFragment = SearchFileHit.getSingleFragment(this.highlight, FileMapping.PATH);
        Optional<String> filenameFragment = SearchFileHit.getSingleFragment(this.highlight, FileMapping.FILENAME);
        return HighlightedPathConverter.convert(this.path, pathFragment, filenameFragment);
    }

    private static Optional<String> getSingleFragment(ObjectContent highlight, FileMapping field) {
        if (highlight == null) {
            return Optional.empty();
        }
        List fragments = highlight.getArray(field.fieldName());
        if (fragments.size() == 1) {
            return Optional.ofNullable((String)((Content)fragments.get(0)).accept(ContentVisitors.stringContentVisitor()));
        }
        return Optional.empty();
    }

    private static class Excerpts {
        private final Highlight highlight;

        private Excerpts(Highlight highlight) {
            this.highlight = highlight;
        }

        Optional<Highlight> forContentField() {
            return Optional.ofNullable(this.highlight);
        }
    }

    private static class Highlight {
        private final List<HitContext> content;

        private Highlight(List<HitContext> content) {
            this.content = content;
        }
    }

    private static class FileHitHighlightVisitor
    implements ContentVisitor<Excerpts> {
        private static final FileHitHighlightVisitor instance = new FileHitHighlightVisitor();

        private FileHitHighlightVisitor() {
        }

        public Excerpts visit(@Nonnull ObjectContent source) {
            List<HitContext> fieldExcerpts = Objects.requireNonNull(source, "source").getArray("content").stream().map(content -> (String)content.accept(ContentVisitors.stringContentVisitor())).map(excerpt -> new HighlightedContentToHitContextFunction().apply((String)excerpt)).collect(Collectors.toList());
            return new Excerpts(new Highlight(fieldExcerpts));
        }
    }
}

