/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.search.convert;

import com.atlassian.bitbucket.internal.search.common.mapping.ProjectMapping;
import com.atlassian.elasticsearch.client.content.ObjectContent;
import com.atlassian.elasticsearch.client.search.Hit;

public class SearchProjectHit {
    private final int id;
    private final String key;
    private final String name;

    private SearchProjectHit(int id, String key, String name) {
        this.id = id;
        this.key = key;
        this.name = name;
    }

    public static SearchProjectHit of(Hit hit) {
        int id = Integer.parseInt(hit.getId());
        ObjectContent source = (ObjectContent)hit.getSource().orElseThrow(() -> new IllegalStateException("Project hit does not have a source"));
        return SearchProjectHit.of(id, source);
    }

    public int getId() {
        return this.id;
    }

    public String getKey() {
        return this.key;
    }

    public String getName() {
        return this.name;
    }

    private static SearchProjectHit of(int id, ObjectContent source) {
        String key = source.getStringOrThrow(ProjectMapping.KEY.fieldName());
        String name = source.getStringOrThrow(ProjectMapping.NAME.fieldName());
        return new SearchProjectHit(id, key, name);
    }
}

