/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.search.convert;

import com.atlassian.elasticsearch.client.content.ObjectContent;
import com.atlassian.elasticsearch.client.search.Hit;
import java.util.Optional;

public class SearchRepositoryHit {
    private final int id;
    private final String name;
    private final Integer originId;
    private final int projectId;
    private final double score;
    private final String slug;

    private SearchRepositoryHit(int id, int projectId, String slug, String name, Integer originId, double score) {
        this.id = id;
        this.projectId = projectId;
        this.slug = slug;
        this.name = name;
        this.score = score;
        this.originId = originId;
    }

    public static Optional<SearchRepositoryHit> of(Hit hit) {
        int id = Integer.parseInt(hit.getId());
        return hit.getSource().flatMap(source -> SearchRepositoryHit.of(id, source, hit.getScore()));
    }

    public static Optional<SearchRepositoryHit> ofDocument(ObjectContent content) {
        int id = Integer.parseInt(content.getStringOrThrow("_id"));
        ObjectContent source = content.getObjectContentOrThrow("_source");
        return SearchRepositoryHit.of(id, source, 0.0);
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Integer getOriginId() {
        return this.originId;
    }

    public int getProjectId() {
        return this.projectId;
    }

    public double getScore() {
        return this.score;
    }

    public String getSlug() {
        return this.slug;
    }

    private static Optional<SearchRepositoryHit> of(int id, ObjectContent source, double score) {
        return source.getString("slug").flatMap(slug -> source.getString("name").flatMap(name -> source.getNumber("projectId").flatMap(projectId -> source.getBoolean("fork").map(isFork -> new SearchRepositoryHit(id, projectId.intValue(), (String)slug, (String)name, source.getNumber("originId").map(Number::intValue).orElse(null), score)))));
    }
}

