/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.search.permission;

import com.atlassian.bitbucket.internal.search.search.permission.EffectivePermissions;
import com.atlassian.bitbucket.internal.search.search.permission.PermissionLevel;
import jakarta.annotation.Nonnull;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;

public class SimpleEffectivePermissions
implements EffectivePermissions {
    private final boolean canAccessPublicRepositories;
    private final PermissionLevel globalPermissionLevel;
    private final Set<Integer> projectIds;
    private final Set<Integer> repositoryIds;

    private SimpleEffectivePermissions(Builder builder) {
        this.globalPermissionLevel = Objects.requireNonNull(builder.globalPermissionLevel, "globalPermissionLevel");
        this.projectIds = Objects.requireNonNull(builder.projectIds, "projectIds");
        this.repositoryIds = Objects.requireNonNull(builder.repositoryIds, "repositoryIds");
        this.canAccessPublicRepositories = builder.canAccessPublicRepositories;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    @Nonnull
    public Set<Integer> accessibleProjects() {
        return this.projectIds;
    }

    @Override
    @Nonnull
    public Set<Integer> accessibleRepositories() {
        return this.repositoryIds;
    }

    @Override
    public boolean canAccessPublicRepositories() {
        return this.canAccessPublicRepositories;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SimpleEffectivePermissions)) {
            return false;
        }
        SimpleEffectivePermissions that = (SimpleEffectivePermissions)o;
        return Objects.equals(this.canAccessPublicRepositories, that.canAccessPublicRepositories) && Objects.equals((Object)this.globalPermissionLevel, (Object)that.globalPermissionLevel) && Objects.equals(this.projectIds, that.projectIds) && Objects.equals(this.repositoryIds, that.repositoryIds);
    }

    @Override
    @Nonnull
    public PermissionLevel globalPermissionLevel() {
        return this.globalPermissionLevel;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.canAccessPublicRepositories, this.globalPermissionLevel, this.projectIds, this.repositoryIds});
    }

    public String toString() {
        return "SimpleEffectivePermissions{globalPermissionLevel=" + String.valueOf((Object)this.globalPermissionLevel) + ", projectIds=" + String.valueOf(this.projectIds) + ", repositoryIds=" + String.valueOf(this.repositoryIds) + "}";
    }

    public static final class Builder {
        public boolean canAccessPublicRepositories;
        private PermissionLevel globalPermissionLevel = PermissionLevel.NONE;
        private Set<Integer> projectIds = Collections.emptySet();
        private Set<Integer> repositoryIds = Collections.emptySet();

        private Builder() {
        }

        @Nonnull
        public SimpleEffectivePermissions build() {
            return new SimpleEffectivePermissions(this);
        }

        @Nonnull
        public Builder canAccessPublicRepositories(boolean canAccessPublicRepositories) {
            this.canAccessPublicRepositories = canAccessPublicRepositories;
            return this;
        }

        @Nonnull
        public Builder globalPermissionLevel(@Nonnull PermissionLevel globalPermissionLevel) {
            this.globalPermissionLevel = Objects.requireNonNull(globalPermissionLevel, "globalPermissionLevel");
            return this;
        }

        @Nonnull
        public Builder projectIds(@Nonnull Set<Integer> projectIds) {
            this.projectIds = Objects.requireNonNull(projectIds, "projectIds");
            return this;
        }

        @Nonnull
        public Builder repositoryIds(@Nonnull Set<Integer> repositoryIds) {
            this.repositoryIds = Objects.requireNonNull(repositoryIds, "repositoryIds");
            return this;
        }
    }
}

