/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.search.permission;

import com.atlassian.bitbucket.internal.search.search.permission.EffectivePermissions;
import com.atlassian.bitbucket.internal.search.search.permission.SecurityContext;
import com.atlassian.bitbucket.user.ApplicationUser;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;
import java.util.Optional;

public class SimpleSecurityContext
implements SecurityContext {
    private final EffectivePermissions effectivePermissions;
    private final ApplicationUser user;

    private SimpleSecurityContext(Builder builder) {
        this.effectivePermissions = builder.effectivePermissions;
        this.user = builder.user;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    @Nonnull
    public Optional<ApplicationUser> getCurrentUser() {
        return Optional.ofNullable(this.user);
    }

    @Override
    @Nonnull
    public EffectivePermissions resolveEffectivePermissions() {
        return this.effectivePermissions;
    }

    public String toString() {
        return "SimpleSecurityContext{effectivePermissions=" + String.valueOf(this.effectivePermissions) + ", user=" + String.valueOf(this.user) + "}";
    }

    public static final class Builder {
        private EffectivePermissions effectivePermissions;
        private ApplicationUser user;

        private Builder() {
        }

        @Nonnull
        public SimpleSecurityContext build() {
            return new SimpleSecurityContext(this);
        }

        @Nonnull
        public Builder effectivePermissions(@Nonnull EffectivePermissions effectivePermissions) {
            this.effectivePermissions = Objects.requireNonNull(effectivePermissions, "effectivePermissions");
            return this;
        }

        @Nonnull
        public Builder user(@Nullable ApplicationUser user) {
            this.user = user;
            return this;
        }
    }
}

