/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.search.query;

import com.atlassian.bitbucket.internal.search.common.mapping.MappingField;
import com.atlassian.bitbucket.internal.search.search.permission.EffectivePermissions;
import com.atlassian.bitbucket.internal.search.search.permission.PermissionLevel;
import com.atlassian.elasticsearch.client.ES;
import com.atlassian.elasticsearch.client.query.BooleanValue;
import com.atlassian.elasticsearch.client.query.NumberValue;
import com.atlassian.elasticsearch.client.query.QueryBuilder;
import com.atlassian.elasticsearch.client.query.Value;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;

public abstract class AbstractSearchQueryBuilder {
    private final MappingField projectIdField;
    private final MappingField publicField;
    private final MappingField repositoryIdField;

    protected AbstractSearchQueryBuilder(MappingField repositoryIdField, MappingField projectIdField, MappingField publicField) {
        this.projectIdField = projectIdField;
        this.publicField = publicField;
        this.repositoryIdField = repositoryIdField;
    }

    protected static Optional<QueryBuilder> combineShouldFilters(List<QueryBuilder> filters) {
        return AbstractSearchQueryBuilder.combineFilters(filters, f -> ES.boolQuery().shoulds((Iterable)f));
    }

    protected Optional<QueryBuilder> createPermissionFilter(EffectivePermissions effectivePermissions) {
        boolean hasGlobalRead = PermissionLevel.READ.equals((Object)effectivePermissions.globalPermissionLevel());
        if (hasGlobalRead) {
            return Optional.empty();
        }
        return Optional.of(this.accessibleRepositories(effectivePermissions));
    }

    private static Iterable<Value> asValues(Collection<Integer> identifiers) {
        return identifiers.stream().map(NumberValue::of).collect(Collectors.toList());
    }

    private static Optional<QueryBuilder> combineFilters(List<QueryBuilder> filters, Function<List<QueryBuilder>, ? extends QueryBuilder> combineFunction) {
        if (filters.isEmpty()) {
            return Optional.empty();
        }
        if (filters.size() == 1) {
            return Optional.of(filters.get(0));
        }
        return Optional.of(combineFunction.apply(filters));
    }

    private QueryBuilder accessibleRepositories(EffectivePermissions effectivePermissions) {
        ArrayList<Object> filters = new ArrayList<Object>();
        if (!effectivePermissions.accessibleRepositories().isEmpty()) {
            filters.add(ES.termsQuery((String)this.repositoryIdField.fieldName()).values(AbstractSearchQueryBuilder.asValues(effectivePermissions.accessibleRepositories())));
        }
        if (!effectivePermissions.accessibleProjects().isEmpty()) {
            filters.add(ES.termsQuery((String)this.projectIdField.fieldName()).values(AbstractSearchQueryBuilder.asValues(effectivePermissions.accessibleProjects())));
        }
        if (effectivePermissions.canAccessPublicRepositories()) {
            filters.add(this.publicRepositoriesPermissionFilter());
        }
        if (filters.isEmpty()) {
            return ES.termsQuery((String)this.repositoryIdField.fieldName());
        }
        if (filters.size() == 1) {
            return (QueryBuilder)filters.get(0);
        }
        return ES.boolQuery().shoulds(filters);
    }

    private QueryBuilder publicRepositoriesPermissionFilter() {
        return ES.termQuery((String)this.publicField.fieldName()).value((Value)BooleanValue.of((boolean)true));
    }
}

