/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.search.query;

import com.atlassian.bitbucket.internal.search.common.mapping.FileMapping;
import com.atlassian.bitbucket.internal.search.search.permission.EffectivePermissions;
import com.atlassian.bitbucket.internal.search.search.query.AbstractSearchQueryBuilder;
import com.atlassian.bitbucket.internal.search.search.query.Modifier;
import com.atlassian.bitbucket.internal.search.search.query.PathModifierParser;
import com.atlassian.bitbucket.internal.search.search.query.Query;
import com.atlassian.bitbucket.internal.search.search.query.SearchQueryBuilder;
import com.atlassian.bitbucket.internal.search.search.query.Utils;
import com.atlassian.bitbucket.internal.search.search.scope.Scope;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.elasticsearch.client.ES;
import com.atlassian.elasticsearch.client.query.BoolQueryBuilder;
import com.atlassian.elasticsearch.client.query.BooleanValue;
import com.atlassian.elasticsearch.client.query.NumberValue;
import com.atlassian.elasticsearch.client.query.QueryBuilder;
import com.atlassian.elasticsearch.client.query.StringValue;
import com.atlassian.elasticsearch.client.query.TermQueryBuilder;
import com.atlassian.elasticsearch.client.query.TermsQueryBuilder;
import com.atlassian.elasticsearch.client.query.Value;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;

public class FileSearchQueryBuilder
extends AbstractSearchQueryBuilder
implements SearchQueryBuilder {
    private final Multimap<String, String> languageMap;

    public FileSearchQueryBuilder(Multimap<String, String> languageMap) {
        super(FileMapping.REPOSITORY_ID, FileMapping.PROJECT_ID, FileMapping.PUBLIC);
        this.languageMap = languageMap;
    }

    @Override
    public QueryBuilder convert(Query query, Scope consistentScope, EffectivePermissions effectivePermissions) {
        BoolQueryBuilder queryBuilder = this.createQuery(query);
        List<QueryBuilder> filters = this.createFilters(query, consistentScope, effectivePermissions);
        queryBuilder.filters(filters);
        PathModifierParser.PathModifierContext pathModifierContext = PathModifierParser.parsePathModifiers(query);
        pathModifierContext.getQuery().ifPresent(arg_0 -> ((BoolQueryBuilder)queryBuilder).must(arg_0));
        pathModifierContext.getFilter().ifPresent(arg_0 -> ((BoolQueryBuilder)queryBuilder).filter(arg_0));
        return queryBuilder;
    }

    private List<QueryBuilder> createFilters(Query query, Scope consistentScope, EffectivePermissions effectivePermissions) {
        ArrayList<QueryBuilder> filters = new ArrayList<QueryBuilder>(this.createScopeFilters(consistentScope));
        filters.addAll(this.createModifierFilters(query));
        this.createPermissionFilter(effectivePermissions).ifPresent(filters::add);
        return filters;
    }

    private List<QueryBuilder> createModifierFilters(Query query) {
        Collection<String> languages;
        Collection<String> extensions;
        ArrayList<QueryBuilder> filters = new ArrayList<QueryBuilder>();
        Collection<String> archived = query.getModifierValue(Modifier.ARCHIVED);
        TermQueryBuilder isArchived = ES.termQuery((String)FileMapping.ARCHIVED.fieldName()).value((Value)BooleanValue.of((boolean)true));
        BoolQueryBuilder notArchived = ES.boolQuery().mustNot((QueryBuilder)isArchived);
        BoolQueryBuilder archivedFilter = ES.boolQuery();
        if (archived.isEmpty()) {
            filters.add((QueryBuilder)archivedFilter.should((QueryBuilder)notArchived));
        } else if (!archived.contains("*")) {
            archived.stream().map(Boolean::parseBoolean).forEach(value -> {
                if (value.booleanValue()) {
                    archivedFilter.should((QueryBuilder)isArchived);
                } else {
                    archivedFilter.should((QueryBuilder)notArchived);
                }
            });
            filters.add((QueryBuilder)archivedFilter);
        }
        Collection<String> forks = query.getModifierValue(Modifier.FORK);
        if (!forks.isEmpty() && !forks.contains("*")) {
            TermsQueryBuilder forkFilter = ES.termsQuery((String)FileMapping.FORK.fieldName());
            forks.stream().map(Boolean::parseBoolean).map(BooleanValue::of).forEach(arg_0 -> ((TermsQueryBuilder)forkFilter).value(arg_0));
            filters.add((QueryBuilder)forkFilter);
        }
        if (!(extensions = query.getModifierValue(Modifier.EXTENSION)).isEmpty()) {
            TermsQueryBuilder extensionFilter = ES.termsQuery((String)FileMapping.EXTENSION.fieldName());
            extensions.stream().map(Utils::standardExtensionTermFunction).forEach(ext -> extensionFilter.value((Value)StringValue.of((String)ext)));
            filters.add((QueryBuilder)extensionFilter);
        }
        if (!(languages = query.getModifierValue(Modifier.LANGUAGE)).isEmpty()) {
            TermsQueryBuilder languageFilter = ES.termsQuery((String)FileMapping.EXTENSION.fieldName());
            languages.stream().map(lang -> this.languageMap.get((Object)lang.toLowerCase(Locale.US))).flatMap(Collection::stream).forEach(ext -> languageFilter.value((Value)StringValue.of((String)ext)));
            filters.add((QueryBuilder)languageFilter);
        }
        return filters;
    }

    private BoolQueryBuilder createQuery(Query query) {
        BoolQueryBuilder scoredQuery = ES.boolQuery();
        scoredQuery.must(query.queryBuilder());
        scoredQuery.should((QueryBuilder)ES.termQuery((String)FileMapping.FORK.fieldName()).value((Value)BooleanValue.of((boolean)false)));
        return scoredQuery;
    }

    private List<QueryBuilder> createScopeFilters(Scope consistentScope) {
        if (!consistentScope.hasConstraints()) {
            return Collections.emptyList();
        }
        Collection<Project> projects = consistentScope.getProjects();
        Collection<Repository> repositories = consistentScope.getRepositories();
        ArrayList<QueryBuilder> filters = new ArrayList<QueryBuilder>();
        if (!projects.isEmpty()) {
            filters.add((QueryBuilder)ES.termsQuery((String)FileMapping.PROJECT_ID.fieldName()).values((Iterable)projects.stream().map(p -> NumberValue.of((Number)p.getId())).collect(Collectors.toList())));
        }
        if (!repositories.isEmpty()) {
            filters.add((QueryBuilder)ES.termsQuery((String)FileMapping.REPOSITORY_ID.fieldName()).values((Iterable)repositories.stream().map(r -> NumberValue.of((Number)r.getId())).collect(Collectors.toList())));
        }
        return filters;
    }
}

