/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.search.query;

import com.atlassian.bitbucket.internal.search.common.mapping.FileMapping;
import com.atlassian.bitbucket.internal.search.search.query.Modifier;
import com.atlassian.bitbucket.internal.search.search.query.PathModifierInvalidException;
import com.atlassian.bitbucket.internal.search.search.query.Query;
import com.atlassian.bitbucket.internal.search.search.query.Utils;
import com.atlassian.elasticsearch.client.ES;
import com.atlassian.elasticsearch.client.query.BoolQueryBuilder;
import com.atlassian.elasticsearch.client.query.QueryBuilder;
import com.atlassian.elasticsearch.client.query.SpanQueryBuilder;
import com.atlassian.elasticsearch.client.query.SpanTermQueryBuilder;
import com.atlassian.elasticsearch.client.query.StringValue;
import com.atlassian.elasticsearch.client.query.TermsQueryBuilder;
import com.atlassian.elasticsearch.client.query.Value;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.stream.Collectors;

class PathModifierParser {
    private PathModifierParser() {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + " only contains static utility methods and should not be instantiated.");
    }

    static PathModifierContext parsePathModifiers(Query query) {
        ArrayList<Object> positiveQueries = new ArrayList<Object>();
        ArrayList negativeQueries = new ArrayList();
        for (String value : query.getModifierValue(Modifier.PATH)) {
            String lastSegment;
            ArrayList<TermsQueryBuilder> queryBuilders = new ArrayList<TermsQueryBuilder>();
            boolean anchorFirst = value.startsWith("/");
            List<String> segments = Arrays.stream(value.split("/")).filter(s -> s.length() > 0).collect(Collectors.toList());
            if (segments.isEmpty()) continue;
            if (((String)segments.get(0)).equals("*")) {
                anchorFirst = false;
            }
            if ((lastSegment = (String)segments.get(segments.size() - 1)).startsWith("*.")) {
                String extensionValue = lastSegment.substring(2);
                if (extensionValue.isEmpty()) {
                    throw new PathModifierInvalidException("Invalid extension at end of path modifier");
                }
                queryBuilders.add(ES.termsQuery((String)FileMapping.EXTENSION.fieldName()).value(Utils.standardExtensionTermFunction(extensionValue)));
                segments = segments.subList(0, segments.size() - 1);
            }
            if (!segments.isEmpty()) {
                PathModifierParser.parsePathParts(segments, anchorFirst).ifPresent(queryBuilders::add);
            }
            if (queryBuilders.size() == 1) {
                positiveQueries.add((QueryBuilder)queryBuilders.get(0));
                continue;
            }
            if (queryBuilders.size() <= 1) continue;
            BoolQueryBuilder boolQueryBuilder = ES.boolQuery();
            queryBuilders.forEach(arg_0 -> ((BoolQueryBuilder)boolQueryBuilder).must(arg_0));
            positiveQueries.add(boolQueryBuilder);
        }
        PathModifierContext.Builder contextBuilder = PathModifierContext.builder();
        if (!positiveQueries.isEmpty()) {
            if (positiveQueries.size() == 1) {
                contextBuilder.query((QueryBuilder)positiveQueries.get(0));
            } else {
                contextBuilder.query((QueryBuilder)ES.boolQuery().shoulds(positiveQueries));
            }
        }
        if (!negativeQueries.isEmpty()) {
            contextBuilder.filter((QueryBuilder)ES.boolQuery().mustNots(negativeQueries));
        }
        return contextBuilder.build();
    }

    private static Optional<SpanQueryBuilder> parsePathParts(List<String> segments, boolean anchorFirst) {
        ArrayList connectedSections = new ArrayList();
        ArrayList<SpanQueryBuilder> currentSection = new ArrayList<SpanQueryBuilder>();
        for (String segment : segments) {
            if (segment.equals("*")) {
                PathModifierParser.mergeSegments(currentSection).ifPresent(connectedSections::add);
                currentSection.clear();
                continue;
            }
            currentSection.add(PathModifierParser.simpleSpanTerm(segment, anchorFirst));
            anchorFirst = false;
        }
        PathModifierParser.mergeSegments(currentSection).ifPresent(connectedSections::add);
        if (connectedSections.size() == 0) {
            return Optional.empty();
        }
        if (connectedSections.size() == 1) {
            return Optional.of((SpanQueryBuilder)connectedSections.get(0));
        }
        return Optional.of(ES.spanNear(connectedSections).slop(100).inOrder(true));
    }

    private static Optional<SpanQueryBuilder> mergeSegments(List<SpanQueryBuilder> currentSection) {
        if (!currentSection.isEmpty()) {
            if (currentSection.size() == 1) {
                return Optional.of(currentSection.get(0));
            }
            return Optional.of(ES.spanNear(currentSection).slop(0).inOrder(true));
        }
        return Optional.empty();
    }

    private static SpanQueryBuilder simpleSpanTerm(String segment, boolean anchorFirst) {
        if (segment.contains("*")) {
            throw new PathModifierInvalidException("Invalid path modifier segment: " + segment);
        }
        SpanTermQueryBuilder term = ES.spanTerm((String)"path").value((Value)StringValue.of((String)segment.toLowerCase(Locale.US)));
        if (anchorFirst) {
            return ES.spanFirst((SpanQueryBuilder)term, (int)1);
        }
        return term;
    }

    public static class PathModifierContext {
        private final Optional<QueryBuilder> query;
        private final Optional<QueryBuilder> filter;

        private PathModifierContext(Builder b) {
            this.query = b.query;
            this.filter = b.filter;
        }

        public Optional<QueryBuilder> getFilter() {
            return this.filter;
        }

        public Optional<QueryBuilder> getQuery() {
            return this.query;
        }

        private static Builder builder() {
            return new Builder();
        }

        private static class Builder {
            private Optional<QueryBuilder> query = Optional.empty();
            private Optional<QueryBuilder> filter = Optional.empty();

            public void query(QueryBuilder query) {
                this.query = Optional.of(query);
            }

            public void filter(QueryBuilder filter) {
                this.filter = Optional.of(filter);
            }

            public PathModifierContext build() {
                return new PathModifierContext(this);
            }
        }
    }
}

