/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.search.query;

import com.atlassian.bitbucket.internal.search.common.mapping.RepositoryMapping;
import com.atlassian.bitbucket.internal.search.search.permission.EffectivePermissions;
import com.atlassian.bitbucket.internal.search.search.query.AbstractSearchQueryBuilder;
import com.atlassian.bitbucket.internal.search.search.query.Query;
import com.atlassian.bitbucket.internal.search.search.query.SearchQueryBuilder;
import com.atlassian.bitbucket.internal.search.search.scope.Scope;
import com.atlassian.elasticsearch.client.ES;
import com.atlassian.elasticsearch.client.query.QueryBuilder;
import java.util.Optional;

public class RepositorySearchQueryBuilder
extends AbstractSearchQueryBuilder
implements SearchQueryBuilder {
    public RepositorySearchQueryBuilder() {
        super(RepositoryMapping.ID, RepositoryMapping.PROJECT_ID, RepositoryMapping.PUBLIC);
    }

    @Override
    public QueryBuilder convert(Query query, Scope consistentScope, EffectivePermissions effectivePermissions) {
        QueryBuilder queryBuilder = query.queryBuilder();
        Optional<QueryBuilder> permissionFilter = this.createPermissionFilter(effectivePermissions);
        return permissionFilter.map(filter -> ES.boolQuery().must(queryBuilder).filter(filter)).orElse(queryBuilder);
    }
}

