/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.search.query.parser;

import com.atlassian.bitbucket.internal.search.common.mapping.RepositoryMapping;
import com.atlassian.bitbucket.internal.search.search.QueryInvalidException;
import com.atlassian.bitbucket.internal.search.search.query.Query;
import com.atlassian.bitbucket.internal.search.search.query.parser.QueryParser;
import com.atlassian.bitbucket.internal.search.search.query.parser.QueryParserHelper;
import com.atlassian.bitbucket.internal.search.search.query.parser.QueryTooLongException;
import com.atlassian.elasticsearch.client.ES;
import com.atlassian.elasticsearch.client.query.ConstantScoreQueryBuilder;
import com.atlassian.elasticsearch.client.query.FieldValueFactorFunctionBuilder;
import com.atlassian.elasticsearch.client.query.FunctionBuilder;
import com.atlassian.elasticsearch.client.query.FunctionScoreQueryBuilder;
import com.atlassian.elasticsearch.client.query.QueryBuilder;
import com.atlassian.elasticsearch.client.query.StringValue;
import com.atlassian.elasticsearch.client.query.Value;
import io.atlassian.fugue.Either;

public abstract class AbstractRepositorySearchQueryParser
implements QueryParser {
    @Override
    public Either<QueryInvalidException, Query> parseRawQuery(String rawQuery) {
        if (rawQuery == null || rawQuery.isEmpty()) {
            return QueryParserHelper.emptyQuery();
        }
        if (rawQuery.length() > 250) {
            return Either.left((Object)new QueryTooLongException("Query exceeds the maximum query length of 250 characters.", 250));
        }
        return this.parseQuery(rawQuery);
    }

    protected static ConstantScoreQueryBuilder projectNamePhraseQuery(String query) {
        return (ConstantScoreQueryBuilder)ES.constantScoreQuery().filter((QueryBuilder)ES.matchPhraseQuery((String)RepositoryMapping.QUICK_SEARCH_PROJECT_NAME.fieldName()).query(QueryParserHelper.limitStringLength(query))).boost((Number)1.75);
    }

    protected static FunctionScoreQueryBuilder projectNameTermQuery(String word) {
        return ES.functionScoreQuery().boostMode(FunctionScoreQueryBuilder.BoostMode.REPLACE).query((QueryBuilder)ES.boolQuery().filter((QueryBuilder)ES.termQuery((String)RepositoryMapping.QUICK_SEARCH_PROJECT_NAME.fieldName()).value((Value)StringValue.of((String)word)))).function((FunctionBuilder)ES.fieldValueFactorFunction().field(RepositoryMapping.QUICK_SEARCH_PROJECT_NAME_LENGTH.fieldName()).modifier(FieldValueFactorFunctionBuilder.Modifier.RECIPROCAL), (Number)1.5);
    }

    protected static ConstantScoreQueryBuilder repoNamePhraseQuery(String query) {
        return (ConstantScoreQueryBuilder)ES.constantScoreQuery().filter((QueryBuilder)ES.matchPhraseQuery((String)RepositoryMapping.QUICK_SEARCH_REPOSITORY_NAME.fieldName()).query(QueryParserHelper.limitStringLength(query))).boost((Number)2);
    }

    protected static FunctionScoreQueryBuilder repoNameTermQuery(String word) {
        return ES.functionScoreQuery().boostMode(FunctionScoreQueryBuilder.BoostMode.REPLACE).query((QueryBuilder)ES.boolQuery().filter((QueryBuilder)ES.termQuery((String)RepositoryMapping.QUICK_SEARCH_REPOSITORY_NAME.fieldName()).value((Value)StringValue.of((String)word)))).function((FunctionBuilder)ES.fieldValueFactorFunction().field(RepositoryMapping.QUICK_SEARCH_REPOSITORY_NAME_LENGTH.fieldName()).modifier(FieldValueFactorFunctionBuilder.Modifier.RECIPROCAL), (Number)5);
    }

    protected abstract Either<QueryInvalidException, Query> parseQuery(String var1);
}

