/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.search.query.parser;

import com.atlassian.bitbucket.internal.search.common.mapping.RepositoryMapping;
import com.atlassian.bitbucket.internal.search.search.QueryInvalidException;
import com.atlassian.bitbucket.internal.search.search.query.Query;
import com.atlassian.bitbucket.internal.search.search.query.parser.QueryParserHelper;
import com.atlassian.bitbucket.internal.search.search.query.parser.RepositoryAndProjectSearchQueryParser;
import com.atlassian.bitbucket.internal.search.search.request.DetailedRepositorySearchRequest;
import com.atlassian.bitbucket.project.ProjectType;
import com.atlassian.bitbucket.repository.RepositoryArchiveFilter;
import com.atlassian.elasticsearch.client.ES;
import com.atlassian.elasticsearch.client.query.BoolQueryBuilder;
import com.atlassian.elasticsearch.client.query.BooleanValue;
import com.atlassian.elasticsearch.client.query.NumberValue;
import com.atlassian.elasticsearch.client.query.QueryBuilder;
import com.atlassian.elasticsearch.client.query.TermQueryBuilder;
import com.atlassian.elasticsearch.client.query.Value;
import io.atlassian.fugue.Either;

public class DetailedRepositorySearchRequestParser {
    private final RepositoryAndProjectSearchQueryParser repositoryAndProjectSearchQueryParser = new RepositoryAndProjectSearchQueryParser(true);

    public Either<QueryInvalidException, Query> convertToQuery(DetailedRepositorySearchRequest searchRequest) {
        BoolQueryBuilder builder = ES.boolQuery();
        if (searchRequest.getArchivedFilter() != RepositoryArchiveFilter.ALL) {
            TermQueryBuilder isArchived = ES.termQuery((String)RepositoryMapping.ARCHIVED.fieldName()).value((Value)BooleanValue.of((boolean)true));
            if (searchRequest.getArchivedFilter() == RepositoryArchiveFilter.ACTIVE) {
                builder.filter((QueryBuilder)ES.boolQuery().mustNot((QueryBuilder)isArchived));
            } else {
                builder.filter((QueryBuilder)isArchived);
            }
        }
        searchRequest.getProjectType().ifPresent(projectType -> {
            builder.filter((QueryBuilder)ES.termQuery((String)RepositoryMapping.PROJECT_TYPE.fieldName()).value((Value)ES.value((int)projectType.getId())));
            if (projectType == ProjectType.PERSONAL) {
                switch (searchRequest.getPersonalProjectType()) {
                    case ACTIVE: {
                        builder.filter((QueryBuilder)ES.termQuery((String)RepositoryMapping.USER_ACTIVE.fieldName()).value((Value)BooleanValue.of((boolean)true)));
                        break;
                    }
                    case INACTIVE: {
                        builder.filter((QueryBuilder)ES.termQuery((String)RepositoryMapping.USER_ACTIVE.fieldName()).value((Value)BooleanValue.of((boolean)false)));
                    }
                }
            }
        });
        searchRequest.getHierarchyId().ifPresent(hierarchyId -> builder.filter((QueryBuilder)ES.termQuery((String)RepositoryMapping.HIERARCHY_ID.fieldName()).value((Value)ES.value((String)hierarchyId))));
        searchRequest.getMaximumSize().ifPresent(size -> builder.filter((QueryBuilder)ES.rangeQuery((String)RepositoryMapping.SIZE.fieldName()).lte((Value)NumberValue.of((Number)size))));
        searchRequest.getMinimumSize().ifPresent(size -> builder.filter((QueryBuilder)ES.rangeQuery((String)RepositoryMapping.SIZE.fieldName()).gte((Value)NumberValue.of((Number)size))));
        searchRequest.getRecentActivityAfter().ifPresent(recentActivityAfter -> builder.filter((QueryBuilder)ES.rangeQuery((String)RepositoryMapping.RECENT_ACTIVITY.fieldName()).gte((Value)NumberValue.of((Number)recentActivityAfter.toEpochMilli()))));
        searchRequest.getRecentActivityBefore().ifPresent(recentActivityBefore -> builder.filter((QueryBuilder)ES.rangeQuery((String)RepositoryMapping.RECENT_ACTIVITY.fieldName()).lte((Value)NumberValue.of((Number)recentActivityBefore.toEpochMilli()))));
        searchRequest.getVisibility().ifPresent(visibility -> {
            switch (visibility) {
                case PRIVATE: {
                    builder.filter((QueryBuilder)ES.termQuery((String)RepositoryMapping.PUBLIC.fieldName()).value((Value)BooleanValue.of((boolean)false)));
                    break;
                }
                case PUBLIC: {
                    builder.filter((QueryBuilder)ES.termQuery((String)RepositoryMapping.PUBLIC.fieldName()).value((Value)BooleanValue.of((boolean)true)));
                }
            }
        });
        String rawQuery = searchRequest.getRawSearchQuery();
        if (rawQuery.isEmpty()) {
            return QueryParserHelper.query((QueryBuilder)builder);
        }
        Either<QueryInvalidException, Query> repositoryAndProjectQuery = this.repositoryAndProjectSearchQueryParser.parseQuery(rawQuery);
        if (repositoryAndProjectQuery.isLeft()) {
            return repositoryAndProjectQuery;
        }
        return QueryParserHelper.query((QueryBuilder)builder.must(((Query)repositoryAndProjectQuery.right().get()).queryBuilder()));
    }
}

