/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.search.query.parser;

import com.atlassian.bitbucket.internal.search.search.QueryInvalidException;
import com.atlassian.bitbucket.internal.search.search.query.Query;
import com.atlassian.bitbucket.internal.search.search.query.parser.ErrorListener;
import com.atlassian.bitbucket.internal.search.search.query.parser.ParseSearchQueryVisitor;
import com.atlassian.bitbucket.internal.search.search.query.parser.QueryEmptyException;
import com.atlassian.bitbucket.internal.search.search.query.parser.QueryParser;
import com.atlassian.bitbucket.internal.search.search.query.parser.QuerySyntaxException;
import com.atlassian.bitbucket.internal.search.search.query.parser.QueryTooLongException;
import com.atlassian.bitbucket.internal.search.search.query.parser.SearchQueryLexer;
import com.atlassian.bitbucket.internal.search.search.query.parser.SearchQueryParser;
import com.atlassian.bitbucket.internal.search.search.query.parser.SimpleQuery;
import com.atlassian.elasticsearch.client.query.QueryBuilder;
import io.atlassian.fugue.Either;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.ANTLRErrorStrategy;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.BailErrorStrategy;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.DefaultErrorStrategy;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.atn.ParserATNSimulator;
import org.antlr.v4.runtime.atn.PredictionMode;
import org.antlr.v4.runtime.misc.ParseCancellationException;
import org.antlr.v4.runtime.tree.ParseTree;

public class FileSearchQueryParser
implements QueryParser {
    private static final int MAX_QUERY_LENGTH = 250;

    @Override
    public Either<QueryInvalidException, Query> parseRawQuery(String rawQuery) {
        SearchQueryParser.QueryContext tree;
        if (rawQuery == null || rawQuery.isEmpty()) {
            return Either.left((Object)new QueryEmptyException("Query was empty"));
        }
        if (rawQuery.length() > 250) {
            return Either.left((Object)new QueryTooLongException("Query exceeds the maximum query length of 250 characters.", 250));
        }
        ErrorListener errorListener = new ErrorListener();
        ANTLRInputStream input = new ANTLRInputStream(rawQuery);
        SearchQueryLexer lexer = new SearchQueryLexer((CharStream)input);
        lexer.removeErrorListeners();
        lexer.addErrorListener((ANTLRErrorListener)errorListener);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        SearchQueryParser parser = new SearchQueryParser((TokenStream)tokens);
        ((ParserATNSimulator)parser.getInterpreter()).setPredictionMode(PredictionMode.SLL);
        parser.removeErrorListeners();
        parser.setErrorHandler((ANTLRErrorStrategy)new BailErrorStrategy());
        try {
            tree = parser.query();
        }
        catch (ParseCancellationException ex) {
            tokens.reset();
            parser.reset();
            parser.addErrorListener((ANTLRErrorListener)errorListener);
            parser.setErrorHandler((ANTLRErrorStrategy)new DefaultErrorStrategy());
            ((ParserATNSimulator)parser.getInterpreter()).setPredictionMode(PredictionMode.LL);
            tree = parser.query();
        }
        if (errorListener.hasError()) {
            return Either.left((Object)new QuerySyntaxException(errorListener.getLastError(), rawQuery));
        }
        ParseSearchQueryVisitor visitor = new ParseSearchQueryVisitor();
        return ((Either)visitor.visit((ParseTree)tree)).map(queryBuilder -> SimpleQuery.builder().parseResult(visitor.getParseResult()).modifiers(visitor.getModifiers()).queryBuilder((QueryBuilder)queryBuilder).build());
    }
}

