/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.search.query.parser;

import com.atlassian.bitbucket.internal.search.common.mapping.FileMapping;
import com.atlassian.bitbucket.internal.search.search.QueryInvalidException;
import com.atlassian.bitbucket.internal.search.search.query.Modifier;
import com.atlassian.bitbucket.internal.search.search.query.Query;
import com.atlassian.bitbucket.internal.search.search.query.parser.QueryEmptyException;
import com.atlassian.bitbucket.internal.search.search.query.parser.QueryPreconditionException;
import com.atlassian.bitbucket.internal.search.search.query.parser.QueryTransformer;
import com.atlassian.bitbucket.internal.search.search.query.parser.SearchQueryBaseVisitor;
import com.atlassian.bitbucket.internal.search.search.query.parser.SearchQueryParser;
import com.atlassian.elasticsearch.client.ES;
import com.atlassian.elasticsearch.client.content.Content;
import com.atlassian.elasticsearch.client.query.BoolQueryBuilder;
import com.atlassian.elasticsearch.client.query.MatchPhraseQueryBuilder;
import com.atlassian.elasticsearch.client.query.MatchQueryBuilder;
import com.atlassian.elasticsearch.client.query.MultiMatchQueryBuilder;
import com.atlassian.elasticsearch.client.query.QueryBuilder;
import com.atlassian.elasticsearch.client.query.StringValue;
import com.atlassian.elasticsearch.client.query.Value;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import io.atlassian.fugue.Either;
import jakarta.annotation.Nonnull;
import java.util.Objects;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTree;

public class ParseSearchQueryVisitor
extends SearchQueryBaseVisitor<Either<QueryInvalidException, QueryBuilder>> {
    private static final int MAX_EXPR_LIMIT = 10;
    private final Multimap<Modifier, String> modifiers = HashMultimap.create();
    private boolean negativeContext = false;
    private int numExpressions;
    private Query.ParseResult parseResult = Query.ParseResult.SUCCESS;

    public Multimap<Modifier, String> getModifiers() {
        return this.modifiers;
    }

    public Query.ParseResult getParseResult() {
        return this.parseResult;
    }

    @Override
    public Either<QueryInvalidException, QueryBuilder> visitBinaryExpr(SearchQueryParser.BinaryExprContext ctx) {
        if (++this.numExpressions >= 10) {
            return Either.left((Object)new QueryPreconditionException(String.format("Number of expressions exceeds limit of %d", 10)));
        }
        return ((Either)this.visit((ParseTree)ctx.expression(0))).flatMap(left -> {
            Token operator = ctx.op;
            if (operator.getText().equals("NOT")) {
                return this.visitWithNegativeContext((ParseTree)ctx.expression(1)).flatMap(right -> Either.right((Object)ES.boolQuery().must(ParseSearchQueryVisitor.zeroTermsQueryWontMatch(left)).mustNot(ParseSearchQueryVisitor.zeroTermsQueryWontMatch(right))));
            }
            return ((Either)this.visit((ParseTree)ctx.expression(1))).flatMap(right -> {
                switch (operator.getText()) {
                    case "AND": {
                        BoolQueryBuilder boolQueryBuilder = ES.boolQuery();
                        ParseSearchQueryVisitor.addAsMustUnlessSingleCharacter(boolQueryBuilder, left);
                        ParseSearchQueryVisitor.addAsMustUnlessSingleCharacter(boolQueryBuilder, right);
                        return Either.right((Object)boolQueryBuilder);
                    }
                    case "OR": {
                        return Either.right((Object)ES.boolQuery().should(left).should(right));
                    }
                }
                return Either.left((Object)new QueryInvalidException("Invalid binary expression, operator '" + operator.getText() + "' not recognized"));
            });
        });
    }

    @Override
    public Either<QueryInvalidException, QueryBuilder> visitBinaryNegatedExpr(SearchQueryParser.BinaryNegatedExprContext ctx) {
        return ((Either)this.visit((ParseTree)ctx.expression())).map(queryBuilder -> {
            String text = ctx.NEGATED_WORD().getText();
            String right = text.substring(1, text.length());
            return ES.boolQuery().must(queryBuilder).mustNot((QueryBuilder)ES.matchQuery((String)FileMapping.CONTENT.fieldName()).query((Value)StringValue.of((String)right)).zeroTermsQuery(MatchQueryBuilder.ZeroTerms.NONE));
        });
    }

    @Override
    public Either<QueryInvalidException, QueryBuilder> visitInvalidQuery(SearchQueryParser.InvalidQueryContext ctx) {
        ctx.modifier().forEach(arg_0 -> ((ParseSearchQueryVisitor)this).visit(arg_0));
        BoolQueryBuilder boolQueryBuilder = ES.boolQuery();
        for (SearchQueryParser.InvalidQueryTokensContext tctx : ctx.invalidQueryTokens()) {
            if (tctx.NEGATED_WORD() != null && ctx.invalidQueryTokens().size() == 1) {
                return Either.left((Object)new QueryEmptyException("The query is effectively empty as the only term in the query is a negated word."));
            }
            if (tctx.term() != null) {
                ((Either)this.visit((ParseTree)tctx.term())).foreach(arg_0 -> ((BoolQueryBuilder)boolQueryBuilder).should(arg_0));
                continue;
            }
            boolQueryBuilder.should(this.codeSearchQuery(tctx.getText()));
        }
        this.parseResult = Query.ParseResult.SUBSTITUTION;
        return Either.right((Object)boolQueryBuilder);
    }

    @Override
    public Either<QueryInvalidException, QueryBuilder> visitModifierArchived(SearchQueryParser.ModifierArchivedContext ctx) {
        this.addModifier(Modifier.ARCHIVED, ParseSearchQueryVisitor.extractModifierValue(ctx.getText()));
        return (Either)super.visitModifierArchived(ctx);
    }

    @Override
    public Either<QueryInvalidException, QueryBuilder> visitModifierExtension(SearchQueryParser.ModifierExtensionContext ctx) {
        this.addModifier(Modifier.EXTENSION, ParseSearchQueryVisitor.extractModifierValue(ctx.getText()));
        return (Either)super.visitModifierExtension(ctx);
    }

    @Override
    public Either<QueryInvalidException, QueryBuilder> visitModifierFork(SearchQueryParser.ModifierForkContext ctx) {
        this.addModifier(Modifier.FORK, ParseSearchQueryVisitor.extractModifierValue(ctx.getText()));
        return (Either)super.visitModifierFork(ctx);
    }

    @Override
    public Either<QueryInvalidException, QueryBuilder> visitModifierLanguage(SearchQueryParser.ModifierLanguageContext ctx) {
        this.addModifier(Modifier.LANGUAGE, ParseSearchQueryVisitor.extractModifierValue(ctx.getText()));
        return (Either)super.visitModifierLanguage(ctx);
    }

    @Override
    public Either<QueryInvalidException, QueryBuilder> visitModifierPath(SearchQueryParser.ModifierPathContext ctx) {
        this.addModifier(Modifier.PATH, ParseSearchQueryVisitor.extractModifierValue(ctx.getText()));
        return (Either)super.visitModifierPath(ctx);
    }

    @Override
    public Either<QueryInvalidException, QueryBuilder> visitModifierProject(SearchQueryParser.ModifierProjectContext ctx) {
        this.addModifier(Modifier.PROJECT, ParseSearchQueryVisitor.extractModifierValue(ctx.getText()));
        return (Either)super.visitModifierProject(ctx);
    }

    @Override
    public Either<QueryInvalidException, QueryBuilder> visitModifierRepo(SearchQueryParser.ModifierRepoContext ctx) {
        this.addModifier(Modifier.REPOSITORY, ParseSearchQueryVisitor.extractModifierValue(ctx.getText()));
        return (Either)super.visitModifierRepo(ctx);
    }

    @Override
    public Either<QueryInvalidException, QueryBuilder> visitParExpr(SearchQueryParser.ParExprContext ctx) {
        return ((Either)this.visit((ParseTree)ctx.expression())).map(ParQueryBuilder::new);
    }

    @Override
    public Either<QueryInvalidException, QueryBuilder> visitPhrase(SearchQueryParser.PhraseContext ctx) {
        return this.codeSearchPhraseQuery(ParseSearchQueryVisitor.stripQuotes(ctx.getText()));
    }

    @Override
    public Either<QueryInvalidException, QueryBuilder> visitTermExpr(SearchQueryParser.TermExprContext ctx) {
        BoolQueryBuilder boolQueryBuilder = ES.boolQuery();
        for (SearchQueryParser.TermContext termContext : ctx.term()) {
            ((Either)this.visit((ParseTree)termContext)).foreach(tc -> ParseSearchQueryVisitor.addAsMustUnlessSingleCharacter(boolQueryBuilder, tc));
        }
        for (SearchQueryParser.ExpressionContext expressionContext : ctx.expression()) {
            ((Either)this.visit((ParseTree)expressionContext)).foreach(arg_0 -> ((BoolQueryBuilder)boolQueryBuilder).must(arg_0));
        }
        return Either.right((Object)ParseSearchQueryVisitor.collapseSingletonBoolQuery((QueryBuilder)boolQueryBuilder));
    }

    @Override
    public Either<QueryInvalidException, QueryBuilder> visitTerms(SearchQueryParser.TermsContext ctx) {
        return Either.right((Object)this.codeSearchQuery(ctx.getText()));
    }

    @Override
    public Either<QueryInvalidException, QueryBuilder> visitValidQuery(SearchQueryParser.ValidQueryContext ctx) {
        Either result;
        ctx.modifier().forEach(arg_0 -> ((ParseSearchQueryVisitor)this).visit(arg_0));
        if (ctx.expression().isEmpty()) {
            return Either.left((Object)new QueryEmptyException("No expression present"));
        }
        if (ctx.expression().size() > 1) {
            BoolQueryBuilder boolQueryBuilder = ES.boolQuery();
            ctx.expression().forEach(expressionContext -> ((Either)this.visit((ParseTree)expressionContext)).foreach(arg_0 -> ((BoolQueryBuilder)boolQueryBuilder).must(arg_0)));
            result = Either.right((Object)boolQueryBuilder);
        } else {
            result = (Either)this.visit((ParseTree)ctx.expression(0));
        }
        this.parseResult = Query.ParseResult.SUCCESS;
        return result.map(ParseSearchQueryVisitor::unwrapMainExpression).map(new QueryTransformer()::flatten);
    }

    private static void addAsMustUnlessSingleCharacter(BoolQueryBuilder boolQueryBuilder, QueryBuilder term) {
        if (ParseSearchQueryVisitor.isSingleCharacterMatch(term)) {
            boolQueryBuilder.should(term);
        } else {
            boolQueryBuilder.must(term);
        }
    }

    private static QueryBuilder collapseSingletonBoolQuery(QueryBuilder queryBuilder) {
        if (queryBuilder instanceof BoolQueryBuilder) {
            BoolQueryBuilder boolQueryBuilder = (BoolQueryBuilder)queryBuilder;
            if (boolQueryBuilder.numClauses() == 1 && boolQueryBuilder.getMusts().size() == 1) {
                return (QueryBuilder)boolQueryBuilder.getMusts().get(0);
            }
            if (boolQueryBuilder.numClauses() == 1 && boolQueryBuilder.getShoulds().size() == 1) {
                return (QueryBuilder)boolQueryBuilder.getShoulds().get(0);
            }
        }
        return queryBuilder;
    }

    private static MatchQueryBuilder contentQuery(String text) {
        return ES.matchQuery((String)FileMapping.CONTENT.fieldName()).query(text).operator(MatchQueryBuilder.Operator.AND);
    }

    private static String extractModifierValue(@Nonnull String modifier) {
        int idx = modifier.indexOf(58);
        if (idx == -1) {
            throw new IllegalArgumentException(String.format("Invalid modifier '%s'. Expected modifier of format 'modifier:value'", modifier));
        }
        return modifier.substring(idx + 1);
    }

    private static boolean isSingleCharacterMatch(QueryBuilder queryBuilder) {
        if (queryBuilder instanceof MatchQueryBuilder) {
            String query = (String)((MatchQueryBuilder)queryBuilder).query().get();
            return query.length() == 1;
        }
        if (queryBuilder instanceof MultiMatchQueryBuilder) {
            String query = (String)((MultiMatchQueryBuilder)queryBuilder).query().get();
            return query.length() == 1;
        }
        if (queryBuilder instanceof MatchPhraseQueryBuilder) {
            String query = ((MatchPhraseQueryBuilder)queryBuilder).query();
            return query.length() == 1;
        }
        if (queryBuilder instanceof BoolQueryBuilder) {
            BoolQueryBuilder boolQuery = (BoolQueryBuilder)queryBuilder;
            if (!boolQuery.getMusts().isEmpty()) {
                return boolQuery.getMusts().stream().anyMatch(ParseSearchQueryVisitor::isSingleCharacterMatch);
            }
            return boolQuery.getShoulds().stream().anyMatch(ParseSearchQueryVisitor::isSingleCharacterMatch);
        }
        return false;
    }

    private static String stripQuotes(String text) {
        if (text == null || text.isEmpty()) {
            return text;
        }
        return text.startsWith("\"") && text.endsWith("\"") ? text.substring(1, text.length() - 1) : text;
    }

    private static QueryBuilder unwrapMainExpression(QueryBuilder queryBuilder) {
        if (queryBuilder instanceof ParQueryBuilder) {
            return ((ParQueryBuilder)queryBuilder).queryBuilder;
        }
        return queryBuilder;
    }

    private static QueryBuilder zeroTermsQueryWontMatch(QueryBuilder queryBuilder) {
        if (queryBuilder instanceof MatchQueryBuilder) {
            return ((MatchQueryBuilder)queryBuilder).zeroTermsQuery(MatchQueryBuilder.ZeroTerms.NONE);
        }
        return queryBuilder;
    }

    private void addModifier(@Nonnull Modifier key, @Nonnull String value) {
        this.modifiers.put((Object)Objects.requireNonNull(key, "key"), (Object)Objects.requireNonNull(value, "value"));
    }

    private QueryBuilder codeSearchQuery(String text) {
        MatchQueryBuilder contentQuery = ParseSearchQueryVisitor.contentQuery(text);
        if (this.negativeContext) {
            return contentQuery;
        }
        MatchQueryBuilder pathQuery = ES.matchQuery((String)FileMapping.PATH.fieldName()).query(text).operator(MatchQueryBuilder.Operator.AND);
        MatchPhraseQueryBuilder filenameQuery = ES.matchPhraseQuery((String)FileMapping.FILENAME.fieldName()).query(text);
        return ES.boolQuery().should((QueryBuilder)contentQuery).should((QueryBuilder)pathQuery).should((QueryBuilder)filenameQuery);
    }

    private Either<QueryInvalidException, QueryBuilder> codeSearchPhraseQuery(String text) {
        MatchPhraseQueryBuilder contentQuery = ES.matchPhraseQuery((String)FileMapping.CONTENT.fieldName()).query(text);
        if (this.negativeContext) {
            return Either.right((Object)contentQuery);
        }
        MatchPhraseQueryBuilder pathQuery = ES.matchPhraseQuery((String)FileMapping.PATH.fieldName()).query(text);
        return Either.right((Object)ES.boolQuery().should((QueryBuilder)contentQuery).should((QueryBuilder)pathQuery));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Either<QueryInvalidException, QueryBuilder> visitWithNegativeContext(ParseTree tree) {
        boolean previousFilterContext = this.negativeContext;
        try {
            this.negativeContext = true;
            Either either = (Either)this.visit(tree);
            return either;
        }
        finally {
            this.negativeContext = previousFilterContext;
        }
    }

    private static class ParQueryBuilder
    implements QueryBuilder {
        private final QueryBuilder queryBuilder;

        private ParQueryBuilder(QueryBuilder queryBuilder) {
            this.queryBuilder = queryBuilder;
        }

        @Nonnull
        public Content build() {
            return this.queryBuilder.build();
        }
    }
}

