/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.search.query.parser;

import com.atlassian.bitbucket.internal.search.search.QueryInvalidException;
import com.atlassian.bitbucket.internal.search.search.query.Query;
import com.atlassian.bitbucket.internal.search.search.query.parser.QueryEmptyException;
import com.atlassian.bitbucket.internal.search.search.query.parser.SimpleQuery;
import com.atlassian.elasticsearch.client.query.QueryBuilder;
import io.atlassian.fugue.Either;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class QueryParserHelper {
    static final int MAX_QUERY_LENGTH = 250;
    static final Pattern WORD_CHARACTERS = Pattern.compile("\\w+", 256);

    static List<String> analyze(String input) {
        ArrayList<String> words = new ArrayList<String>();
        Matcher matcher = WORD_CHARACTERS.matcher(input);
        while (matcher.find()) {
            String word = matcher.group().toLowerCase(Locale.ENGLISH);
            words.add(QueryParserHelper.limitStringLength(word));
        }
        return words;
    }

    static Either<QueryInvalidException, Query> emptyQuery() {
        return Either.left((Object)new QueryEmptyException("Query is empty"));
    }

    static String limitStringLength(String string) {
        if (string.codePointCount(0, string.length()) > 20) {
            int index = string.offsetByCodePoints(0, 20);
            return string.substring(0, index);
        }
        return string;
    }

    static Either<QueryInvalidException, Query> query(QueryBuilder queryBuilder) {
        return Either.right((Object)SimpleQuery.builder().queryBuilder(queryBuilder).build());
    }
}

