/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.search.query.parser;

import com.atlassian.elasticsearch.client.query.BoolQueryBuilder;
import com.atlassian.elasticsearch.client.query.QueryBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

class QueryTransformer {
    QueryTransformer() {
    }

    public QueryBuilder flatten(QueryBuilder queryBuilder) {
        if (!(queryBuilder instanceof BoolQueryBuilder)) {
            return queryBuilder;
        }
        BoolQueryBuilder parent = (BoolQueryBuilder)queryBuilder;
        new ArrayList<QueryBuilder>(parent.getMusts()).forEach(must -> parent.replaceMust(must, QueryTransformer.flattenMusts(must)));
        return parent;
    }

    private static List<QueryBuilder> flattenMusts(QueryBuilder parent) {
        if (QueryTransformer.isMustOnly(parent)) {
            BoolQueryBuilder bool = (BoolQueryBuilder)parent;
            return bool.getMusts().stream().flatMap(must -> QueryTransformer.flattenMusts(must).stream()).collect(Collectors.toList());
        }
        return Collections.singletonList(parent);
    }

    private static boolean isMustOnly(QueryBuilder queryBuilder) {
        if (queryBuilder instanceof BoolQueryBuilder) {
            BoolQueryBuilder bool = (BoolQueryBuilder)queryBuilder;
            return bool.numClauses() == bool.getMusts().size();
        }
        return false;
    }
}

