/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.search.query.parser;

import com.atlassian.bitbucket.internal.search.common.mapping.RepositoryMapping;
import com.atlassian.bitbucket.internal.search.search.QueryInvalidException;
import com.atlassian.bitbucket.internal.search.search.query.Query;
import com.atlassian.bitbucket.internal.search.search.query.parser.AbstractRepositorySearchQueryParser;
import com.atlassian.bitbucket.internal.search.search.query.parser.QueryParserHelper;
import com.atlassian.elasticsearch.client.ES;
import com.atlassian.elasticsearch.client.query.BoolQueryBuilder;
import com.atlassian.elasticsearch.client.query.ConstantScoreQueryBuilder;
import com.atlassian.elasticsearch.client.query.FieldValueFactorFunctionBuilder;
import com.atlassian.elasticsearch.client.query.FunctionBuilder;
import com.atlassian.elasticsearch.client.query.FunctionScoreQueryBuilder;
import com.atlassian.elasticsearch.client.query.QueryBuilder;
import com.atlassian.elasticsearch.client.query.StringValue;
import com.atlassian.elasticsearch.client.query.Value;
import io.atlassian.fugue.Either;
import java.util.List;

public class RepositoryAndProjectSearchQueryParser
extends AbstractRepositorySearchQueryParser {
    private static final String PROJECT_MODIFIER = "/";
    private static final double REPOSITORY_DESCRIPTION_PHRASE_BOOST = 1.5;
    private static final double REPOSITORY_DESCRIPTION_TERM_WEIGHT = 0.5;
    private final boolean matchRepositoryDescription;

    public RepositoryAndProjectSearchQueryParser() {
        this.matchRepositoryDescription = false;
    }

    public RepositoryAndProjectSearchQueryParser(boolean matchRepositoryDescription) {
        this.matchRepositoryDescription = matchRepositoryDescription;
    }

    @Override
    protected Either<QueryInvalidException, Query> parseQuery(String rawQuery) {
        String[] splitQuery = rawQuery.split(String.valueOf(PROJECT_MODIFIER), 2);
        if (splitQuery.length == 2) {
            String projectPortion = splitQuery[0];
            String repoPortion = splitQuery[1];
            return this.projectSlashRepoQuery(projectPortion, repoPortion);
        }
        return this.freeFormQuery(rawQuery);
    }

    private Either<QueryInvalidException, Query> freeFormQuery(String rawQuery) {
        List<String> words = QueryParserHelper.analyze(rawQuery);
        BoolQueryBuilder wordsQuery = ES.boolQuery();
        for (String word : words) {
            BoolQueryBuilder wordQuery = ES.boolQuery().should((QueryBuilder)RepositoryAndProjectSearchQueryParser.projectNameTermQuery(word)).should((QueryBuilder)RepositoryAndProjectSearchQueryParser.repoNameTermQuery(word));
            if (this.matchRepositoryDescription) {
                wordQuery.should((QueryBuilder)this.repositoryDescriptionTermQuery(word));
            }
            wordsQuery.must((QueryBuilder)wordQuery);
        }
        if (wordsQuery.isEmpty()) {
            return QueryParserHelper.emptyQuery();
        }
        if (wordsQuery.getMusts().size() == 1 && wordsQuery.numClauses() == 1) {
            return QueryParserHelper.query((QueryBuilder)wordsQuery.getMusts().get(0));
        }
        ConstantScoreQueryBuilder repoNamePhraseQuery = RepositoryAndProjectSearchQueryParser.repoNamePhraseQuery(rawQuery);
        ConstantScoreQueryBuilder projectNamePhraseQuery = RepositoryAndProjectSearchQueryParser.projectNamePhraseQuery(rawQuery);
        BoolQueryBuilder query = ES.boolQuery().should((QueryBuilder)wordsQuery).should((QueryBuilder)repoNamePhraseQuery).should((QueryBuilder)projectNamePhraseQuery);
        if (this.matchRepositoryDescription) {
            query.should((QueryBuilder)this.repositoryDescriptionPhraseQuery(rawQuery));
        }
        return QueryParserHelper.query((QueryBuilder)query);
    }

    private Either<QueryInvalidException, Query> projectSlashRepoQuery(String projectPortion, String repoPortion) {
        List<String> projectWords = QueryParserHelper.analyze(projectPortion);
        List<String> repoWords = QueryParserHelper.analyze(repoPortion);
        BoolQueryBuilder query = ES.boolQuery();
        for (String projectWord : projectWords) {
            query.must((QueryBuilder)RepositoryAndProjectSearchQueryParser.projectNameTermQuery(projectWord));
        }
        for (String repoWord : repoWords) {
            query.must((QueryBuilder)RepositoryAndProjectSearchQueryParser.repoNameTermQuery(repoWord));
        }
        if (repoWords.size() > 1) {
            ConstantScoreQueryBuilder repoNamePhraseQuery = RepositoryAndProjectSearchQueryParser.repoNamePhraseQuery(repoPortion);
            query.should((QueryBuilder)repoNamePhraseQuery);
        }
        if (query.isEmpty()) {
            return QueryParserHelper.emptyQuery();
        }
        if (query.getMusts().size() == 1 && query.numClauses() == 1) {
            return QueryParserHelper.query((QueryBuilder)query.getMusts().get(0));
        }
        return QueryParserHelper.query((QueryBuilder)query);
    }

    private ConstantScoreQueryBuilder repositoryDescriptionPhraseQuery(String query) {
        return (ConstantScoreQueryBuilder)ES.constantScoreQuery().filter((QueryBuilder)ES.matchPhraseQuery((String)RepositoryMapping.QUICK_SEARCH_REPOSITORY_DESCRIPTION.fieldName()).query(query)).boost((Number)1.5);
    }

    private FunctionScoreQueryBuilder repositoryDescriptionTermQuery(String word) {
        return ES.functionScoreQuery().boostMode(FunctionScoreQueryBuilder.BoostMode.REPLACE).query((QueryBuilder)ES.boolQuery().filter((QueryBuilder)ES.termQuery((String)RepositoryMapping.QUICK_SEARCH_REPOSITORY_DESCRIPTION.fieldName()).value((Value)StringValue.of((String)word)))).function((FunctionBuilder)ES.fieldValueFactorFunction().field(RepositoryMapping.QUICK_SEARCH_REPOSITORY_DESCRIPTION_LENGTH.fieldName()).modifier(FieldValueFactorFunctionBuilder.Modifier.RECIPROCAL), (Number)0.5);
    }
}

