/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.search.query.parser;

import com.atlassian.bitbucket.internal.search.common.mapping.FileMapping;
import com.atlassian.bitbucket.internal.search.search.QueryInvalidException;
import com.atlassian.bitbucket.internal.search.search.query.Query;
import com.atlassian.bitbucket.internal.search.search.query.parser.QueryParserHelper;
import com.atlassian.elasticsearch.client.ES;
import com.atlassian.elasticsearch.client.query.BoolQueryBuilder;
import com.atlassian.elasticsearch.client.query.NumberValue;
import com.atlassian.elasticsearch.client.query.QueryBuilder;
import com.atlassian.elasticsearch.client.query.TermQueryBuilder;
import com.atlassian.elasticsearch.client.query.TermsQueryBuilder;
import io.atlassian.fugue.Either;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;

@Component
public class RepositoryFileSearchQueryParser {
    public Either<QueryInvalidException, Query> convertToQuery(@Nonnull String rootFile, @Nonnull List<Integer> repositoryIds) {
        Objects.requireNonNull(rootFile, "rootFile");
        Objects.requireNonNull(repositoryIds, "repositoryIds");
        BoolQueryBuilder queryBuilder = ES.boolQuery();
        TermQueryBuilder rootFileQueryBuilder = new TermQueryBuilder(FileMapping.PATH.fieldName());
        rootFileQueryBuilder.value(rootFile);
        queryBuilder.must((QueryBuilder)rootFileQueryBuilder);
        if (!repositoryIds.isEmpty()) {
            TermsQueryBuilder repositoriesQueryBuilder = ES.termsQuery((String)FileMapping.REPOSITORY_ID.fieldName()).values((Iterable)repositoryIds.stream().map(NumberValue::of).collect(Collectors.toList()));
            queryBuilder.filter((QueryBuilder)repositoriesQueryBuilder);
        }
        return QueryParserHelper.query((QueryBuilder)queryBuilder);
    }
}

