/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.search.query.parser;

import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.internal.search.common.mapping.RepositoryMapping;
import com.atlassian.bitbucket.internal.search.search.QueryInvalidException;
import com.atlassian.bitbucket.internal.search.search.query.Query;
import com.atlassian.bitbucket.internal.search.search.query.parser.RepositoryAndProjectSearchQueryParser;
import com.atlassian.bitbucket.internal.search.search.query.parser.RepositorySearchQueryParser;
import com.atlassian.bitbucket.internal.search.search.query.parser.SimpleQuery;
import com.atlassian.bitbucket.internal.search.search.request.RepositoryFilterRequest;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.project.ProjectService;
import com.atlassian.bitbucket.repository.RepositoryArchiveFilter;
import com.atlassian.bitbucket.user.UserType;
import com.atlassian.elasticsearch.client.ES;
import com.atlassian.elasticsearch.client.query.BoolQueryBuilder;
import com.atlassian.elasticsearch.client.query.BooleanValue;
import com.atlassian.elasticsearch.client.query.NumberValue;
import com.atlassian.elasticsearch.client.query.QueryBuilder;
import com.atlassian.elasticsearch.client.query.TermQueryBuilder;
import com.atlassian.elasticsearch.client.query.Value;
import io.atlassian.fugue.Either;
import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RepositoryFilterRequestParser {
    private final AuthenticationContext authenticationContext;
    private final ProjectService projectService;
    private final RepositoryAndProjectSearchQueryParser repositoryAndProjectParser = new RepositoryAndProjectSearchQueryParser();
    private final RepositorySearchQueryParser repositoryParser = new RepositorySearchQueryParser();

    @Autowired
    public RepositoryFilterRequestParser(AuthenticationContext authenticationContext, ProjectService projectService) {
        this.authenticationContext = authenticationContext;
        this.projectService = projectService;
    }

    public Either<QueryInvalidException, Query> convertToQuery(RepositoryFilterRequest request) {
        String filter = request.getFilter().orElse(null);
        BoolQueryBuilder queryBuilder = ES.boolQuery();
        if (StringUtils.isNotEmpty((CharSequence)filter)) {
            Either<QueryInvalidException, Query> eitherQuery = request.getProjectId().isPresent() ? this.repositoryParser.parseRawQuery(filter) : this.repositoryAndProjectParser.parseRawQuery(filter);
            if (eitherQuery.isLeft()) {
                return eitherQuery;
            }
            queryBuilder.must(((Query)eitherQuery.right().get()).queryBuilder());
        } else {
            queryBuilder.must((QueryBuilder)ES.boolQuery());
            this.getPersonalProjectId().ifPresent(projectId -> queryBuilder.should((QueryBuilder)ES.constantScoreQuery().filter((QueryBuilder)ES.termQuery((String)RepositoryMapping.PROJECT_ID.fieldName()).value((Value)NumberValue.of((Number)projectId))).boost((Number)10)));
        }
        if (request.getArchiveFilter() != RepositoryArchiveFilter.ALL) {
            TermQueryBuilder isArchived = ES.termQuery((String)RepositoryMapping.ARCHIVED.fieldName()).value((Value)BooleanValue.of((boolean)true));
            if (request.getArchiveFilter() == RepositoryArchiveFilter.ACTIVE) {
                queryBuilder.filter((QueryBuilder)ES.boolQuery().mustNot((QueryBuilder)isArchived));
            } else {
                queryBuilder.filter((QueryBuilder)isArchived);
            }
        }
        request.getOriginId().ifPresent(originId -> queryBuilder.filter((QueryBuilder)this.originIdFilter((Integer)originId)));
        request.getProjectId().ifPresent(projectId -> queryBuilder.filter((QueryBuilder)this.projectIdFilter((Integer)projectId)));
        return Either.right((Object)SimpleQuery.builder().queryBuilder((QueryBuilder)queryBuilder).build());
    }

    private Optional<Integer> getPersonalProjectId() {
        return Optional.ofNullable(this.authenticationContext.getCurrentUser()).filter(user -> user.getType() == UserType.NORMAL).map(user -> "~" + user.getSlug()).map(arg_0 -> ((ProjectService)this.projectService).getByKey(arg_0)).map(Project::getId);
    }

    @Nonnull
    private TermQueryBuilder originIdFilter(@Nonnull Integer originId) {
        return ES.termQuery((String)RepositoryMapping.ORIGIN_ID.fieldName()).value((Value)NumberValue.of((Number)Objects.requireNonNull(originId, "originId")));
    }

    @Nonnull
    private TermQueryBuilder projectIdFilter(@Nonnull Integer projectId) {
        return ES.termQuery((String)RepositoryMapping.PROJECT_ID.fieldName()).value((Value)NumberValue.of((Number)Objects.requireNonNull(projectId, "projectId")));
    }
}

