/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.search.query.parser;

import com.atlassian.bitbucket.internal.search.search.QueryInvalidException;
import com.atlassian.bitbucket.internal.search.search.query.Query;
import com.atlassian.bitbucket.internal.search.search.query.parser.AbstractRepositorySearchQueryParser;
import com.atlassian.bitbucket.internal.search.search.query.parser.QueryParserHelper;
import com.atlassian.elasticsearch.client.ES;
import com.atlassian.elasticsearch.client.query.BoolQueryBuilder;
import com.atlassian.elasticsearch.client.query.QueryBuilder;
import io.atlassian.fugue.Either;
import java.util.List;

public class RepositorySearchQueryParser
extends AbstractRepositorySearchQueryParser {
    @Override
    protected Either<QueryInvalidException, Query> parseQuery(String rawQuery) {
        List<String> words = QueryParserHelper.analyze(rawQuery);
        if (words.isEmpty()) {
            return QueryParserHelper.emptyQuery();
        }
        if (words.size() == 1) {
            return QueryParserHelper.query((QueryBuilder)RepositorySearchQueryParser.repoNameTermQuery(words.get(0)));
        }
        BoolQueryBuilder wordsQuery = ES.boolQuery();
        for (String word : words) {
            wordsQuery.must((QueryBuilder)RepositorySearchQueryParser.repoNameTermQuery(word));
        }
        return QueryParserHelper.query((QueryBuilder)ES.boolQuery().should((QueryBuilder)wordsQuery).should((QueryBuilder)RepositorySearchQueryParser.repoNamePhraseQuery(rawQuery)));
    }
}

