/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.search.query.parser;

import com.atlassian.bitbucket.internal.search.search.query.Modifier;
import com.atlassian.bitbucket.internal.search.search.query.Query;
import com.atlassian.elasticsearch.client.query.QueryBuilder;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import jakarta.annotation.Nonnull;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;

public class SimpleQuery
implements Query {
    private final Multimap<Modifier, String> modifiers;
    private final Query.ParseResult parseResult;
    private final QueryBuilder queryBuilder;

    private SimpleQuery(Builder builder) {
        this.modifiers = Objects.requireNonNull(builder.modifiers, "modifiers");
        this.parseResult = Objects.requireNonNull(builder.parseResult, "parseResult");
        this.queryBuilder = Objects.requireNonNull(builder.queryBuilder, "queryBuilder");
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    @Nonnull
    public Collection<String> getModifierValue(Modifier modifier) {
        return Collections.unmodifiableCollection(this.modifiers.get((Object)modifier));
    }

    @Override
    public boolean hasModifiers() {
        return !this.modifiers.isEmpty();
    }

    @Override
    @Nonnull
    public Query.ParseResult parseResult() {
        return this.parseResult;
    }

    @Override
    @Nonnull
    public QueryBuilder queryBuilder() {
        return this.queryBuilder;
    }

    public String toString() {
        return "SimpleQuery{modifiers=" + String.valueOf(this.modifiers) + ", parseResult='" + String.valueOf((Object)this.parseResult) + "', queryBuilder='" + String.valueOf(this.queryBuilder) + "'}";
    }

    public static final class Builder {
        private Multimap<Modifier, String> modifiers = ArrayListMultimap.create();
        private Query.ParseResult parseResult = Query.ParseResult.SUCCESS;
        private QueryBuilder queryBuilder;

        private Builder() {
        }

        @Nonnull
        public SimpleQuery build() {
            return new SimpleQuery(this);
        }

        public Builder modifiers(Multimap<Modifier, String> modifiers) {
            this.modifiers = Objects.requireNonNull(modifiers, "modifiers");
            return this;
        }

        @Nonnull
        public Builder parseResult(@Nonnull Query.ParseResult parseResult) {
            this.parseResult = Objects.requireNonNull(parseResult, "parseResult");
            return this;
        }

        @Nonnull
        public Builder queryBuilder(@Nonnull QueryBuilder queryBuilder) {
            this.queryBuilder = Objects.requireNonNull(queryBuilder, "queryBuilder");
            return this;
        }
    }
}

