/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.search.request;

import com.atlassian.bitbucket.internal.search.search.request.DefaultSearchPagingInfo;
import com.atlassian.bitbucket.internal.search.search.request.FilterRequest;
import com.atlassian.bitbucket.internal.search.search.request.SearchPagingInfo;
import com.atlassian.bitbucket.util.PageRequest;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;
import java.util.Optional;

public abstract class AbstractFilterRequest
implements FilterRequest {
    protected final String filter;
    protected final SearchPagingInfo pagingInfo;

    protected AbstractFilterRequest(AbstractBuilder builder) {
        this.filter = builder.filter;
        this.pagingInfo = builder.pagingInfo;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbstractFilterRequest)) {
            return false;
        }
        AbstractFilterRequest that = (AbstractFilterRequest)o;
        return Objects.equals(this.pagingInfo, that.pagingInfo) && Objects.equals(this.filter, that.filter);
    }

    @Override
    @Nonnull
    public Optional<String> getFilter() {
        return Optional.ofNullable(this.filter);
    }

    @Override
    @Nonnull
    public Optional<SearchPagingInfo> getSearchPagingInfo() {
        if (this.pagingInfo != null && this.pagingInfo.isValid(this.getMaxPageSize())) {
            return Optional.of(this.pagingInfo);
        }
        return Optional.empty();
    }

    public int hashCode() {
        return Objects.hash(this.pagingInfo, this.filter);
    }

    protected abstract int getMaxPageSize();

    public static abstract class AbstractBuilder<B extends AbstractBuilder<B>> {
        private String filter;
        private SearchPagingInfo pagingInfo;

        @Nonnull
        public B filter(@Nullable String filter) {
            this.filter = filter;
            return this.self();
        }

        @Nonnull
        public B pageRequest(PageRequest pageRequest) {
            Objects.requireNonNull(pageRequest, "pageRequest");
            this.pagingInfo = ((DefaultSearchPagingInfo.Builder)((DefaultSearchPagingInfo.Builder)DefaultSearchPagingInfo.builder().offset(pageRequest.getStart())).pageSize(pageRequest.getLimit())).build();
            return this.self();
        }

        @Nonnull
        public B searchPagingInfo(@Nonnull SearchPagingInfo pagingInfo) {
            this.pagingInfo = Objects.requireNonNull(pagingInfo, "pagingInfo");
            return this.self();
        }

        @Nonnull
        protected abstract B self();
    }
}

