/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.search.request;

import com.atlassian.bitbucket.internal.search.search.request.DefaultSearchRequest;
import com.atlassian.bitbucket.internal.search.search.request.DetailedRepositorySearchRequest;
import com.atlassian.bitbucket.internal.search.search.request.DetailedRepositorySortOrder;
import com.atlassian.bitbucket.internal.search.search.request.PersonalProjectType;
import com.atlassian.bitbucket.project.ProjectType;
import com.atlassian.bitbucket.repository.RepositoryArchiveFilter;
import com.atlassian.bitbucket.repository.RepositoryVisibility;
import com.google.common.base.MoreObjects;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.Instant;
import java.util.Objects;
import java.util.Optional;

public class DefaultDetailedRepositorySearchRequest
extends DefaultSearchRequest
implements DetailedRepositorySearchRequest {
    private final RepositoryArchiveFilter archived;
    private final DetailedRepositorySortOrder detailedRepositorySortOrder;
    private final String hierarchyId;
    private final Long maximumSize;
    private final Long minimumSize;
    private final PersonalProjectType personalProjectType;
    private final ProjectType projectType;
    private final Instant recentActivityAfter;
    private final Instant recentActivityBefore;
    private final RepositoryVisibility visibility;

    private DefaultDetailedRepositorySearchRequest(@Nonnull Builder builder) {
        super(builder);
        this.archived = builder.archived;
        this.detailedRepositorySortOrder = builder.detailedRepositorySortOrder;
        this.hierarchyId = builder.hierarchyId;
        this.maximumSize = builder.maximumSize;
        this.minimumSize = builder.minimumSize;
        this.personalProjectType = builder.personalProjectType;
        this.projectType = builder.projectType;
        this.recentActivityAfter = builder.recentActivityAfter;
        this.recentActivityBefore = builder.recentActivityBefore;
        this.visibility = builder.visibility;
    }

    @Override
    @Nonnull
    public RepositoryArchiveFilter getArchivedFilter() {
        return this.archived;
    }

    @Override
    @Nonnull
    public DetailedRepositorySortOrder getDetailedRepositorySortOrder() {
        return this.detailedRepositorySortOrder;
    }

    @Override
    @Nonnull
    public Optional<String> getHierarchyId() {
        return Optional.ofNullable(this.hierarchyId);
    }

    @Override
    @Nonnull
    public Optional<Long> getMaximumSize() {
        return Optional.ofNullable(this.maximumSize);
    }

    @Override
    @Nonnull
    public Optional<Long> getMinimumSize() {
        return Optional.ofNullable(this.minimumSize);
    }

    @Override
    @Nonnull
    public PersonalProjectType getPersonalProjectType() {
        return this.personalProjectType;
    }

    @Override
    @Nonnull
    public Optional<ProjectType> getProjectType() {
        return Optional.ofNullable(this.projectType);
    }

    @Override
    @Nonnull
    public Optional<Instant> getRecentActivityAfter() {
        return Optional.ofNullable(this.recentActivityAfter);
    }

    @Override
    @Nonnull
    public Optional<Instant> getRecentActivityBefore() {
        return Optional.ofNullable(this.recentActivityBefore);
    }

    @Override
    @Nonnull
    public Optional<RepositoryVisibility> getVisibility() {
        return Optional.ofNullable(this.visibility);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("pagingInfo", (Object)this.pagingInfo).add("detailedRepositorySortOrder", (Object)this.detailedRepositorySortOrder).add("hierarchyId", (Object)this.hierarchyId).add("maximumSize", (Object)this.maximumSize).add("minimumSize", (Object)this.minimumSize).add("rawSearchQuery", (Object)this.rawSearchQuery).add("personalProjectType", (Object)this.personalProjectType).add("projectType", (Object)this.projectType).add("recentActivityAfter", (Object)this.recentActivityAfter).add("recentActivityBefore", (Object)this.recentActivityBefore).add("visibility", (Object)this.visibility).add("archived", (Object)this.archived).toString();
    }

    public static class Builder
    extends DefaultSearchRequest.AbstractBuilder<Builder> {
        private RepositoryArchiveFilter archived = RepositoryArchiveFilter.ACTIVE;
        private DetailedRepositorySortOrder detailedRepositorySortOrder = DetailedRepositorySortOrder.SEARCH_SCORE;
        private String hierarchyId;
        private Long maximumSize;
        private Long minimumSize;
        private PersonalProjectType personalProjectType = PersonalProjectType.ALL;
        private ProjectType projectType;
        private Instant recentActivityAfter;
        private Instant recentActivityBefore;
        private RepositoryVisibility visibility;

        @Override
        @Nonnull
        public DefaultDetailedRepositorySearchRequest build() {
            return new DefaultDetailedRepositorySearchRequest(this);
        }

        @Nonnull
        public Builder archived(@Nullable RepositoryArchiveFilter archived) {
            if (archived != null) {
                this.archived = archived;
            }
            return this;
        }

        @Nonnull
        public Builder detailedRepositorySortOrder(@Nonnull DetailedRepositorySortOrder detailedRepositorySortOrder) {
            this.detailedRepositorySortOrder = Objects.requireNonNull(detailedRepositorySortOrder, "detailedRepositorySortOrder");
            return this;
        }

        @Nonnull
        public Builder hierarchyId(@Nullable String hierarchyId) {
            this.hierarchyId = hierarchyId;
            return this;
        }

        @Nonnull
        public Builder maximumSize(@Nullable Long maximumSize) {
            this.maximumSize = maximumSize;
            return this;
        }

        @Nonnull
        public Builder minimumSize(@Nullable Long minimumSize) {
            this.minimumSize = minimumSize;
            return this;
        }

        @Nonnull
        public Builder personalProjectType(@Nonnull PersonalProjectType personalProjectType) {
            this.personalProjectType = Objects.requireNonNull(personalProjectType, "personalProjectType");
            return this;
        }

        @Nonnull
        public Builder projectType(@Nullable ProjectType projectType) {
            this.projectType = projectType;
            return this;
        }

        @Nonnull
        public Builder recentActivityAfter(@Nullable Instant recentActivityAfter) {
            this.recentActivityAfter = recentActivityAfter;
            return this;
        }

        @Nonnull
        public Builder recentActivityBefore(@Nullable Instant recentActivityBefore) {
            this.recentActivityBefore = recentActivityBefore;
            return this;
        }

        @Nonnull
        public Builder visibility(@Nullable RepositoryVisibility visibility) {
            this.visibility = visibility;
            return this;
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }
    }
}

