/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.search.request;

import com.atlassian.bitbucket.internal.search.search.request.AbstractFilterRequest;
import com.atlassian.bitbucket.internal.search.search.request.RepositoryFilterRequest;
import com.atlassian.bitbucket.internal.search.search.request.SearchPagingInfo;
import com.atlassian.bitbucket.repository.RepositoryArchiveFilter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;
import java.util.Optional;

public class DefaultRepositoryFilterRequest
extends AbstractFilterRequest
implements RepositoryFilterRequest {
    private static final int MAX_PAGE_SIZE = Integer.getInteger("index.repository.resultWindow.max", 1000);
    private final Integer originId;
    private final Integer projectId;
    private final RepositoryArchiveFilter archived;

    private DefaultRepositoryFilterRequest(Builder builder) {
        super(builder);
        this.archived = builder.archived;
        this.originId = builder.originId;
        this.projectId = builder.projectId;
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DefaultRepositoryFilterRequest)) {
            return false;
        }
        DefaultRepositoryFilterRequest that = (DefaultRepositoryFilterRequest)o;
        return Objects.equals(this.pagingInfo, that.pagingInfo) && Objects.equals(this.originId, that.originId) && Objects.equals(this.filter, that.filter);
    }

    @Override
    @Nonnull
    public Optional<String> getFilter() {
        return Optional.ofNullable(this.filter);
    }

    @Override
    @Nonnull
    public RepositoryArchiveFilter getArchiveFilter() {
        return this.archived;
    }

    @Override
    @Nonnull
    public Optional<Integer> getOriginId() {
        return Optional.ofNullable(this.originId);
    }

    @Override
    @Nonnull
    public Optional<Integer> getProjectId() {
        return Optional.ofNullable(this.projectId);
    }

    @Override
    @Nonnull
    public Optional<SearchPagingInfo> getSearchPagingInfo() {
        if (this.pagingInfo != null && this.pagingInfo.isValid(MAX_PAGE_SIZE)) {
            return Optional.of(this.pagingInfo);
        }
        return Optional.empty();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.pagingInfo, this.filter, this.originId);
    }

    public String toString() {
        return "DefaultRepositoryFilterRequest{pagingInfo=" + String.valueOf(this.pagingInfo) + ", archived='" + this.archived.flag() + "', filter='" + this.filter + "', originId=" + this.originId + "}";
    }

    @Override
    protected int getMaxPageSize() {
        return MAX_PAGE_SIZE;
    }

    public static class Builder
    extends AbstractFilterRequest.AbstractBuilder<Builder> {
        private RepositoryArchiveFilter archived = RepositoryArchiveFilter.ACTIVE;
        private Integer originId;
        private Integer projectId;

        private Builder() {
        }

        @Nonnull
        public DefaultRepositoryFilterRequest build() {
            return new DefaultRepositoryFilterRequest(this);
        }

        @Nonnull
        public Builder archived(@Nullable RepositoryArchiveFilter archived) {
            if (archived != null) {
                this.archived = archived;
            }
            return this;
        }

        @Nonnull
        public Builder originId(@Nonnull Integer originId) {
            this.originId = Objects.requireNonNull(originId, "originId");
            return this;
        }

        @Nonnull
        public Builder projectId(@Nonnull Integer projectId) {
            this.projectId = Objects.requireNonNull(projectId, "projectId");
            return this;
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }
    }
}

