/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.search.request;

import com.atlassian.bitbucket.internal.search.search.request.SearchPagingInfo;
import com.atlassian.bitbucket.internal.search.search.request.SearchRequest;
import com.atlassian.bitbucket.util.BuilderSupport;
import jakarta.annotation.Nonnull;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class DefaultSearchRequest
implements SearchRequest {
    private static final int MAX_PAGE_SIZE = Integer.getInteger("index.codesearch.resultWindow.max", 1000);
    final Map<SearchRequest.SearchRequestType, SearchPagingInfo> pagingInfo;
    final String rawSearchQuery;

    DefaultSearchRequest(@Nonnull AbstractBuilder<?> builder) {
        this.pagingInfo = builder.pagingInfo;
        this.rawSearchQuery = builder.rawSearchQuery;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DefaultSearchRequest)) {
            return false;
        }
        DefaultSearchRequest that = (DefaultSearchRequest)o;
        return Objects.equals(this.pagingInfo, that.pagingInfo) && Objects.equals(this.rawSearchQuery, that.rawSearchQuery);
    }

    @Override
    @Nonnull
    public String getRawSearchQuery() {
        return this.rawSearchQuery;
    }

    @Override
    @Nonnull
    public Optional<SearchPagingInfo> getSearchPagingInfo(@Nonnull SearchRequest.SearchRequestType searchRequestType) {
        return Optional.ofNullable(this.pagingInfo.get((Object)Objects.requireNonNull(searchRequestType, "searchRequestType"))).flatMap(p -> p.isValid(MAX_PAGE_SIZE) ? Optional.of(p) : Optional.empty());
    }

    public int hashCode() {
        return Objects.hash(this.pagingInfo, this.rawSearchQuery);
    }

    public String toString() {
        return "DefaultSearchRequest{pagingInfo=" + String.valueOf(this.pagingInfo) + ", rawSearchQuery='" + this.rawSearchQuery + "'}";
    }

    public static abstract class AbstractBuilder<T extends AbstractBuilder<T>>
    extends BuilderSupport {
        private Map<SearchRequest.SearchRequestType, SearchPagingInfo> pagingInfo = new HashMap<SearchRequest.SearchRequestType, SearchPagingInfo>();
        private String rawSearchQuery;

        protected AbstractBuilder() {
        }

        @Nonnull
        public abstract DefaultSearchRequest build();

        public T rawSearchQuery(@Nonnull String rawSearchQuery) {
            this.rawSearchQuery = Objects.requireNonNull(rawSearchQuery, "rawSearchQuery");
            return this.self();
        }

        public T searchPagingInfo(@Nonnull SearchRequest.SearchRequestType requestType, @Nonnull SearchPagingInfo pagingInfo) {
            this.pagingInfo.put(Objects.requireNonNull(requestType, "requestType"), Objects.requireNonNull(pagingInfo, "pagingInfo"));
            return this.self();
        }

        @Nonnull
        protected abstract T self();
    }

    public static class Builder
    extends AbstractBuilder<Builder> {
        @Override
        @Nonnull
        public DefaultSearchRequest build() {
            return new DefaultSearchRequest(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }
    }
}

