/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.search.rest;

import com.atlassian.bitbucket.internal.search.search.rest.RestResultCategory;
import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.annotation.Nonnull;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public abstract class AbstractSearchResults<T, B extends Builder<T, B>> {
    private final RestResultCategory category;
    private final long count;
    private final boolean isLastPage;
    private final int nextStart;
    private final int start;
    private final List<T> values;

    protected AbstractSearchResults(Builder<T, B> builder) {
        this.category = builder.category;
        this.count = builder.hitCount;
        this.isLastPage = builder.isLastPage;
        this.start = builder.start;
        this.nextStart = builder.nextStart;
        this.values = builder.values;
    }

    @JsonProperty
    public RestResultCategory getCategory() {
        return this.category;
    }

    @JsonProperty
    public long getCount() {
        return this.count;
    }

    @JsonProperty
    public int getNextStart() {
        return this.nextStart;
    }

    @JsonProperty
    public int getStart() {
        return this.start;
    }

    @JsonProperty
    public List<T> getValues() {
        return Collections.unmodifiableList(this.values);
    }

    @JsonProperty(value="isLastPage")
    public boolean isLastPage() {
        return this.isLastPage;
    }

    public static abstract class Builder<T, B> {
        private RestResultCategory category;
        private long hitCount;
        private boolean isLastPage;
        private int nextStart;
        private int start;
        private List<T> values = Collections.emptyList();

        public B hitCount(long hitCount) {
            this.hitCount = hitCount;
            return this.self();
        }

        public B isLastPage(boolean isLastPage) {
            this.isLastPage = isLastPage;
            return this.self();
        }

        public B nextStart(int nextStart) {
            this.nextStart = nextStart;
            return this.self();
        }

        public B resultCategory(@Nonnull RestResultCategory resultCategory) {
            this.category = Objects.requireNonNull(resultCategory);
            return this.self();
        }

        public B start(int start) {
            this.start = start;
            return this.self();
        }

        public B values(@Nonnull List<T> values) {
            this.values = Objects.requireNonNull(values);
            return this.self();
        }

        protected abstract B self();
    }
}

