/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.search.rest;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.search.search.QueryInvalidException;
import com.atlassian.bitbucket.internal.search.search.QueryInvalidSearchOffsetException;
import com.atlassian.bitbucket.internal.search.search.query.parser.QueryTooLongException;
import com.atlassian.bitbucket.internal.search.search.scope.OrphanRepositoryModifierException;
import com.atlassian.bitbucket.rest.v2.api.RestErrorMessage;
import com.atlassian.bitbucket.rest.v2.api.RestErrors;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.ExceptionMapper;
import jakarta.ws.rs.ext.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
@Singleton
public class QueryInvalidExceptionMapper
implements ExceptionMapper<QueryInvalidException> {
    private static final Logger log = LoggerFactory.getLogger(QueryInvalidExceptionMapper.class);
    private final I18nService i18nService;

    @Inject
    public QueryInvalidExceptionMapper(I18nService i18nService) {
        this.i18nService = i18nService;
    }

    public Response toResponse(QueryInvalidException ex) {
        RestErrors errors = new RestErrors.Builder().add(new RestErrorMessage(null, this.getMessage(ex), ex.getClass().getSimpleName())).build();
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errors).build();
    }

    private String getMessage(QueryInvalidException exception) {
        if (exception instanceof QueryTooLongException) {
            return this.i18nService.getMessage("bitbucket.search.exception.querytoolong", new Object[]{((QueryTooLongException)exception).getMaxLength()});
        }
        if (exception instanceof OrphanRepositoryModifierException) {
            return this.i18nService.getMessage("bitbucket.search.exception.orphanrepositorymodifier", new Object[0]);
        }
        if (exception instanceof QueryInvalidSearchOffsetException) {
            return this.i18nService.getMessage("bitbucket.search.exception.invalidsearchoffset", new Object[]{exception.getMessage()});
        }
        log.warn("Unhandled exception without localization {} for query `{}`: {}", new Object[]{exception.getClass().getCanonicalName(), exception.getRawQuery().orElse(""), exception.getLocalizedMessage()});
        return this.i18nService.getMessage("bitbucket.search.exception.unknown", new Object[]{exception.getClass().getSimpleName()});
    }
}

