/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.search.rest;

import com.atlassian.bitbucket.internal.search.search.rest.AbstractSearchResults;
import com.atlassian.bitbucket.internal.search.search.rest.RestFileHit;
import com.atlassian.bitbucket.internal.search.search.rest.RestResultCategory;
import com.atlassian.bitbucket.internal.search.search.rest.aggregation.Aggregations;
import com.atlassian.bitbucket.internal.search.search.result.FileSearchResult;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"category", "isLastPage", "count", "start", "nextStart", "aggregations", "values"})
public class RestCodeSearchResults
extends AbstractSearchResults<RestFileHit, Builder> {
    private final Aggregations aggregations;

    private RestCodeSearchResults(Builder builder) {
        super(builder);
        this.aggregations = builder.aggregations;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static RestCodeSearchResults emptyCodeSearchResults(RestResultCategory category) {
        return ((Builder)((Builder)((Builder)((Builder)RestCodeSearchResults.builder().resultCategory(category)).isLastPage(true)).hitCount(0L)).start(1)).build();
    }

    @JsonProperty
    @JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
    public Aggregations getAggregations() {
        return this.aggregations;
    }

    public static class Builder
    extends AbstractSearchResults.Builder<RestFileHit, Builder> {
        private Aggregations aggregations;

        private Builder() {
        }

        public Builder aggregations(Aggregations aggregations) {
            this.aggregations = aggregations;
            return this.self();
        }

        public RestCodeSearchResults build() {
            return new RestCodeSearchResults(this);
        }

        public Builder fileHits(@Nonnull List<RestFileHit> hits) {
            this.values(Objects.requireNonNull(hits, "hits"));
            return this.self();
        }

        public Builder fileSearchResultsData(FileSearchResult fileSearchResult) {
            Objects.requireNonNull(fileSearchResult, "fileSearchResult");
            this.start(fileSearchResult.getOffset());
            this.nextStart(fileSearchResult.getOffset() + fileSearchResult.getPageSize());
            this.isLastPage(fileSearchResult.isLastPage());
            this.hitCount(fileSearchResult.getTotalHitCount());
            return this.self();
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

