/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.search.rest;

import com.atlassian.bitbucket.internal.search.search.rest.RestHitContext;
import com.atlassian.bitbucket.internal.search.search.rest.RestSegment;
import com.atlassian.bitbucket.internal.search.search.result.FileHit;
import com.atlassian.bitbucket.rest.v2.api.repository.RestRepository;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nonnull;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"repository", "file", "hitContexts", "pathMatches"})
public class RestFileHit {
    private final String file;
    private final List<RestHitContext> hitContexts;
    private final int hitCount;
    private final List<RestSegment> pathMatches;
    private final RestRepository repository;

    private RestFileHit(Builder builder) {
        this.file = builder.file;
        this.hitContexts = builder.hitContexts;
        this.pathMatches = builder.pathMatches;
        this.repository = builder.repository;
        this.hitCount = builder.hitCount;
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonProperty
    public String getFile() {
        return this.file;
    }

    @JsonProperty
    public List<RestHitContext> getHitContexts() {
        return this.hitContexts;
    }

    @JsonProperty
    public int getHitCount() {
        return this.hitCount;
    }

    @JsonProperty
    public List<RestSegment> getPathMatches() {
        return this.pathMatches;
    }

    @JsonProperty
    public RestRepository getRepository() {
        return this.repository;
    }

    public static final class Builder {
        private String file;
        private List<RestHitContext> hitContexts = Collections.emptyList();
        private int hitCount;
        private List<RestSegment> pathMatches = Collections.emptyList();
        private RestRepository repository;

        private Builder() {
        }

        public RestFileHit build() {
            return new RestFileHit(this);
        }

        public Builder hit(@Nonnull FileHit hit) {
            Objects.requireNonNull(hit, "hit");
            this.file = hit.getPath();
            return this;
        }

        public Builder hitContexts(@Nonnull List<RestHitContext> hitContexts) {
            this.hitContexts = Objects.requireNonNull(hitContexts, "hitContexts");
            return this;
        }

        public Builder hitCount(int hitCount) {
            this.hitCount = hitCount;
            return this;
        }

        public Builder pathMatches(@Nonnull List<RestSegment> pathMatches) {
            this.pathMatches = Objects.requireNonNull(pathMatches, "pathMatches");
            return this;
        }

        public Builder repository(@Nonnull RestRepository repository) {
            this.repository = Objects.requireNonNull(repository, "repository");
            return this;
        }
    }
}

