/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.search.rest;

import com.atlassian.bitbucket.internal.search.search.result.HitContext;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import jakarta.annotation.Nonnull;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class RestHitContext {
    private final int firstLineNumber;
    private final int hitCount;
    private final List<String> lines;

    private RestHitContext(Builder builder) {
        this.firstLineNumber = builder.firstLineNumber;
        this.lines = builder.lines;
        this.hitCount = builder.hitCount;
    }

    public static Builder builder() {
        return new Builder();
    }

    public int getHitCount() {
        return this.hitCount;
    }

    @JsonValue
    public List<Line> toJson() {
        return IntStream.range(this.firstLineNumber, this.firstLineNumber + this.lines.size()).mapToObj(i -> new Line(i, this.lines.get(i - this.firstLineNumber))).collect(Collectors.toList());
    }

    public static class Builder {
        private int firstLineNumber;
        private int hitCount;
        private List<String> lines = Collections.emptyList();

        private Builder() {
        }

        public RestHitContext build() {
            return new RestHitContext(this);
        }

        public Builder context(@Nonnull HitContext ctx) {
            Objects.requireNonNull(ctx, "ctx");
            this.firstLineNumber = ctx.getFirstLineNumber();
            this.lines = ctx.getLines();
            this.hitCount = ctx.getHitCount();
            return this;
        }
    }

    public static class Line {
        private final int line;
        private final String text;

        public Line(int line, String text) {
            this.line = line;
            this.text = text;
        }

        @JsonProperty
        public int getLine() {
            return this.line;
        }

        @JsonProperty
        public String getText() {
            return this.text;
        }
    }
}

