/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.search.rest;

import com.atlassian.bitbucket.internal.search.search.rest.AbstractSearchResults;
import com.atlassian.bitbucket.internal.search.search.result.ProjectSearchResult;
import com.atlassian.bitbucket.rest.v2.api.project.RestProject;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Objects;

public class RestProjectSearchResults
extends AbstractSearchResults<RestProject, Builder> {
    private RestProjectSearchResults(Builder builder) {
        super(builder);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends AbstractSearchResults.Builder<RestProject, Builder> {
        private Builder() {
        }

        public RestProjectSearchResults build() {
            return new RestProjectSearchResults(this);
        }

        public Builder projectSearchResultsData(@Nonnull ProjectSearchResult projectSearchResult) {
            Objects.requireNonNull(projectSearchResult, "projectSearchResult");
            this.start(projectSearchResult.getOffset());
            this.nextStart(projectSearchResult.getOffset() + projectSearchResult.getPageSize());
            this.isLastPage(projectSearchResult.isLastPage());
            this.hitCount(projectSearchResult.getTotalHitCount());
            return this.self();
        }

        public Builder projectSearchResultsRepositories(@Nonnull List<RestProject> projects) {
            this.values(Objects.requireNonNull(projects, "projects"));
            return this.self();
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

