/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.search.rest;

import com.atlassian.bitbucket.internal.search.search.query.Query;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

public class RestQuery {
    private final boolean substituted;

    protected RestQuery(Builder builder) {
        this.substituted = builder.substitued;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(Query query) {
        return new Builder().substituted(query.parseResult() == Query.ParseResult.SUBSTITUTION);
    }

    @JsonSerialize
    public boolean isSubstituted() {
        return this.substituted;
    }

    public static class Builder {
        private boolean substitued = false;

        public RestQuery build() {
            return new RestQuery(this);
        }

        public Builder substituted(boolean substituted) {
            this.substitued = substituted;
            return this;
        }
    }
}

