/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.search.rest;

import com.atlassian.bitbucket.internal.search.search.rest.AbstractSearchResults;
import com.atlassian.bitbucket.internal.search.search.rest.RestResultCategory;
import com.atlassian.bitbucket.internal.search.search.result.RepositorySearchResult;
import com.atlassian.bitbucket.rest.v2.api.repository.RestRepository;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Objects;

public class RestRepositorySearchResults
extends AbstractSearchResults<RestRepository, Builder> {
    private RestRepositorySearchResults(Builder builder) {
        super(builder);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static RestRepositorySearchResults emptyRepositorySearchResults(RestResultCategory category) {
        return ((Builder)((Builder)((Builder)((Builder)RestRepositorySearchResults.builder().resultCategory(category)).isLastPage(true)).hitCount(0L)).start(1)).build();
    }

    public static class Builder
    extends AbstractSearchResults.Builder<RestRepository, Builder> {
        private Builder() {
        }

        public RestRepositorySearchResults build() {
            return new RestRepositorySearchResults(this);
        }

        public Builder repositorySearchResultsData(@Nonnull RepositorySearchResult repositorySearchResult) {
            Objects.requireNonNull(repositorySearchResult, "repositorySearchResult");
            this.start(repositorySearchResult.getOffset());
            this.nextStart(repositorySearchResult.getOffset() + repositorySearchResult.getPageSize());
            this.isLastPage(repositorySearchResult.isLastPage());
            this.hitCount(repositorySearchResult.getTotalHitCount());
            return this.self();
        }

        public Builder repositorySearchResultsRepositories(@Nonnull List<RestRepository> repositories) {
            this.values(Objects.requireNonNull(repositories, "repositories"));
            return this.self();
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

