/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.search.rest;

import com.atlassian.bitbucket.internal.search.search.result.ResultScopeType;
import com.atlassian.bitbucket.rest.v2.api.project.RestProject;
import com.atlassian.bitbucket.rest.v2.api.repository.RestRepository;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.Optional;

public class RestResultScope {
    private final Optional<RestProject> project;
    private final Optional<RestRepository> repository;
    private final ResultScopeType resultScopeType;

    @Deprecated
    public RestResultScope() {
        this.resultScopeType = ResultScopeType.GLOBAL;
        this.repository = Optional.empty();
        this.project = Optional.empty();
    }

    private RestResultScope(Builder builder) {
        this.resultScopeType = builder.resultScopeType;
        this.repository = builder.repository;
        this.project = builder.project;
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonSerialize(include=JsonSerialize.Inclusion.NON_DEFAULT)
    public Optional<RestProject> getProject() {
        return this.project;
    }

    @JsonSerialize(include=JsonSerialize.Inclusion.NON_DEFAULT)
    public Optional<RestRepository> getRepository() {
        return this.repository;
    }

    @JsonSerialize
    public ResultScopeType getType() {
        return this.resultScopeType;
    }

    public static class Builder {
        private Optional<RestProject> project = Optional.empty();
        private Optional<RestRepository> repository = Optional.empty();
        private ResultScopeType resultScopeType = ResultScopeType.GLOBAL;

        public RestResultScope build() {
            return new RestResultScope(this);
        }

        public Builder project(@Nonnull Optional<RestProject> project) {
            this.project = Objects.requireNonNull(project, "project");
            return this;
        }

        public Builder repository(@Nonnull Optional<RestRepository> repository) {
            this.repository = Objects.requireNonNull(repository, "repository");
            return this;
        }

        public Builder scopeType(@Nonnull ResultScopeType resultScopeType) {
            this.resultScopeType = Objects.requireNonNull(resultScopeType, "resultScopeType");
            return this;
        }
    }
}

