/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.search.rest;

import com.atlassian.bitbucket.internal.search.search.rest.RestCodeSearchResults;
import com.atlassian.bitbucket.internal.search.search.rest.RestProjectSearchResults;
import com.atlassian.bitbucket.internal.search.search.rest.RestQuery;
import com.atlassian.bitbucket.internal.search.search.rest.RestRepositorySearchResults;
import com.atlassian.bitbucket.internal.search.search.rest.RestResultScope;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.Optional;

@JsonPropertyOrder(value={"scope", "code", "repositories", "query"})
public class RestSearchResult {
    private final Optional<RestCodeSearchResults> code;
    private final Optional<RestProjectSearchResults> projects;
    private final Optional<RestQuery> query;
    private final Optional<RestRepositorySearchResults> repositories;
    private final RestResultScope scope;

    protected RestSearchResult(Builder builder) {
        this.code = Optional.ofNullable(builder.codeSearchResults);
        this.projects = Optional.ofNullable(builder.projectSearchResults);
        this.repositories = Optional.ofNullable(builder.repositorySearchResults);
        this.scope = builder.scope;
        this.query = Optional.ofNullable(builder.query);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonSerialize(include=JsonSerialize.Inclusion.NON_DEFAULT)
    public Optional<RestCodeSearchResults> getCode() {
        return this.code;
    }

    @JsonSerialize(include=JsonSerialize.Inclusion.NON_DEFAULT)
    public Optional<RestProjectSearchResults> getProjects() {
        return this.projects;
    }

    @JsonSerialize
    public Optional<RestQuery> getQuery() {
        return this.query;
    }

    @JsonSerialize(include=JsonSerialize.Inclusion.NON_DEFAULT)
    public Optional<RestRepositorySearchResults> getRepositories() {
        return this.repositories;
    }

    @JsonSerialize
    public RestResultScope getScope() {
        return this.scope;
    }

    public static class Builder {
        private RestCodeSearchResults codeSearchResults;
        private RestProjectSearchResults projectSearchResults;
        private RestQuery query;
        private RestRepositorySearchResults repositorySearchResults;
        private RestResultScope scope;

        private Builder() {
        }

        public RestSearchResult build() {
            return new RestSearchResult(this);
        }

        public Builder codeSearchResults(@Nonnull RestCodeSearchResults codeSearchResults) {
            this.codeSearchResults = Objects.requireNonNull(codeSearchResults);
            return this;
        }

        public Builder projectSearchResults(@Nonnull RestProjectSearchResults projectSearchResults) {
            this.projectSearchResults = Objects.requireNonNull(projectSearchResults);
            return this;
        }

        public Builder query(@Nonnull RestQuery query) {
            this.query = Objects.requireNonNull(query);
            return this;
        }

        public Builder repositorySearchResults(@Nonnull RestRepositorySearchResults repositorySearchResults) {
            this.repositorySearchResults = Objects.requireNonNull(repositorySearchResults);
            return this;
        }

        public Builder scope(@Nonnull RestResultScope scope) {
            this.scope = scope;
            return this;
        }
    }
}

