/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.search.rest;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import jakarta.annotation.Nonnull;
import java.util.Objects;

public class RestSegment {
    private final String text;
    private final boolean isMatching;

    private RestSegment(Builder builder) {
        this.text = Objects.requireNonNull(builder.text, "builder.text");
        this.isMatching = builder.isMatching;
    }

    @JsonSerialize
    public String getText() {
        return this.text;
    }

    @JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
    @JsonProperty(value="match")
    public Boolean isMatching() {
        return this.isMatching ? Boolean.TRUE : null;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String text;
        private boolean isMatching;

        private Builder() {
        }

        @Nonnull
        public Builder text(@Nonnull String text) {
            this.text = Objects.requireNonNull(text, "text");
            return this;
        }

        @Nonnull
        public Builder isMatching(boolean isMatching) {
            this.isMatching = isMatching;
            return this;
        }

        @Nonnull
        public RestSegment build() {
            return new RestSegment(this);
        }
    }
}

