/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.search.rest;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.commit.BulkCommitsRequest;
import com.atlassian.bitbucket.commit.Commit;
import com.atlassian.bitbucket.commit.CommitService;
import com.atlassian.bitbucket.commit.SimpleCommit;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.idx.CommitIndex;
import com.atlassian.bitbucket.idx.IndexSearchRequest;
import com.atlassian.bitbucket.internal.search.SearchException;
import com.atlassian.bitbucket.internal.search.common.util.Timing;
import com.atlassian.bitbucket.internal.search.indexing.util.Observables;
import com.atlassian.bitbucket.internal.search.search.QueryInvalidException;
import com.atlassian.bitbucket.internal.search.search.SearchService;
import com.atlassian.bitbucket.internal.search.search.UnsuccessfulResponseException;
import com.atlassian.bitbucket.internal.search.search.permission.SecurityContext;
import com.atlassian.bitbucket.internal.search.search.request.DefaultDetailedRepositorySearchRequest;
import com.atlassian.bitbucket.internal.search.search.request.DefaultRepositoryFileMatchingRequest;
import com.atlassian.bitbucket.internal.search.search.request.DefaultRepositoryFilterRequest;
import com.atlassian.bitbucket.internal.search.search.request.DefaultSearchPagingInfo;
import com.atlassian.bitbucket.internal.search.search.request.DetailedRepositorySortOrder;
import com.atlassian.bitbucket.internal.search.search.request.PersonalProjectType;
import com.atlassian.bitbucket.internal.search.search.request.SearchRequest;
import com.atlassian.bitbucket.internal.search.search.rest.RestSearchRequest;
import com.atlassian.bitbucket.internal.search.search.rest.convert.RestConverter;
import com.atlassian.bitbucket.internal.search.search.rest.convert.ToModel;
import com.atlassian.bitbucket.internal.search.search.result.DetailedRepositorySearchResult;
import com.atlassian.bitbucket.internal.search.search.result.RepositorySearchResult;
import com.atlassian.bitbucket.internal.search.search.result.SearchResult;
import com.atlassian.bitbucket.internal.search.search.security.HostSecurityService;
import com.atlassian.bitbucket.project.ProjectType;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryArchiveFilter;
import com.atlassian.bitbucket.repository.RepositoryVisibility;
import com.atlassian.bitbucket.rest.v2.api.commit.RestCommit;
import com.atlassian.bitbucket.rest.v2.api.repository.RestRepository;
import com.atlassian.bitbucket.rest.v2.api.resolver.PageRequestResolver;
import com.atlassian.bitbucket.rest.v2.api.resolver.ProjectResolver;
import com.atlassian.bitbucket.rest.v2.api.resolver.RepositoryResolver;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.bitbucket.rest.v2.api.util.RestPage;
import com.atlassian.bitbucket.server.Feature;
import com.atlassian.bitbucket.server.FeatureManager;
import com.atlassian.bitbucket.server.StandardFeature;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.bitbucket.validation.ArgumentValidationException;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import com.codahale.metrics.annotation.Timed;
import com.google.common.base.Stopwatch;
import com.google.common.base.Throwables;
import io.atlassian.fugue.Either;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import java.net.ConnectException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;

@AnonymousSiteAccess
@Consumes(value={"application/json"})
@Path(value="/")
@Produces(value={"application/json"})
@Singleton
public class SearchResource {
    private static final int MAX_SEARCH_PAGE_SIZE = Integer.getInteger("index.codesearch.resultWindow.max", 1000);
    private static final int MIN_COMMIT_SEARCH_LENGTH = 7;
    private static final int MIN_REPOSITORY_FILE_MATCH_QUERY_LENGTH = 4;
    private static final Logger log = LoggerFactory.getLogger(SearchResource.class);
    private static final Logger timingLogger = Timing.TIMING_LOGGER;
    private final CommitIndex commitIndex;
    private final CommitService commitService;
    private final FeatureManager featureManager;
    private final HostSecurityService hostSecurityService;
    private final I18nService i18nService;
    private final RestConverter restConverter;
    private final SearchService searchService;

    @Inject
    public SearchResource(CommitIndex commitIndex, CommitService commitService, FeatureManager featureManager, HostSecurityService hostSecurityService, I18nService i18nService, RestConverter restConverter, SearchService searchService) {
        this.i18nService = i18nService;
        this.commitIndex = commitIndex;
        this.commitService = commitService;
        this.featureManager = featureManager;
        this.hostSecurityService = hostSecurityService;
        this.restConverter = restConverter;
        this.searchService = searchService;
    }

    @Path(value="projects/{projectKey}/repos")
    @GET
    @Timed(name="search.rest.resource.repos", absolute=true)
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response filterRepositories(@BeanParam ProjectResolver projectResolver, @QueryParam(value="filter") String filter, @QueryParam(value="archived") RepositoryArchiveFilter archived, @BeanParam PageRequestResolver pageRequestResolver, @Context ContainerRequestContext containerRequestContext) {
        DefaultRepositoryFilterRequest filterRequest = ((DefaultRepositoryFilterRequest.Builder)((DefaultRepositoryFilterRequest.Builder)DefaultRepositoryFilterRequest.builder().projectId(projectResolver.getProject().getId()).filter(StringUtils.trimToNull((String)filter))).archived(archived).pageRequest(pageRequestResolver.getPageRequest())).build();
        return this.processRequest(filterRequest, ((Object)filterRequest).toString(), () -> this.searchService.filterRepositories(this.getSecurityContext(), filterRequest), result -> this.restConverter.convert((RepositorySearchResult)result, pageRequestResolver.getPageRequest(), containerRequestContext));
    }

    @Path(value="/search")
    @POST
    @Timed(name="search.rest.resource", absolute=true)
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response search(RestSearchRequest restSearchRequest, @Context ContainerRequestContext containerRequestContext) {
        Either<SearchException, SearchRequest> searchRequestEither = ToModel.INSTANCE.apply(restSearchRequest);
        return (Response)searchRequestEither.fold(error -> {
            log.debug("Failed to parse search request '{}' - error: {}", (Object)restSearchRequest, (Object)error.getLocalizedMessage());
            throw Throwables.propagate((Throwable)error);
        }, sr -> this.processRequest(restSearchRequest, restSearchRequest.getQuery(), () -> this.searchService.searchFor(this.getSecurityContext(), (SearchRequest)sr), result -> this.restConverter.convert((SearchResult)result, containerRequestContext)));
    }

    @Path(value="/commits")
    @GET
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response searchCommits(@QueryParam(value="query") String query, @BeanParam PageRequestResolver pageRequestResolver) {
        if ((query = StringUtils.trimToEmpty((String)query).toLowerCase(Locale.ROOT)).length() < 7) {
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.search.rest.commits.invalid.query", new Object[0]));
        }
        IndexSearchRequest indexSearchRequest = new IndexSearchRequest.Builder().prefix(query).build();
        Page minimalCommitPage = this.commitIndex.searchRepositoryCommits(indexSearchRequest, pageRequestResolver.getPageRequest());
        if (minimalCommitPage.getSize() == 0) {
            return ResponseFactory.ok((Object)new RestPage(PageUtils.createEmptyPage((PageRequest)pageRequestResolver.getPageRequest()))).build();
        }
        ArrayList commits = new ArrayList(minimalCommitPage.getSize());
        this.commitService.streamCommits(new BulkCommitsRequest.Builder().commits(minimalCommitPage.getValues()).ignoreMissing(true).build(), (commit, repositories) -> {
            SimpleCommit.Builder commitBuilder = new SimpleCommit.Builder(commit);
            for (Repository repo : repositories) {
                commitBuilder.repository(repo);
                commits.add(commitBuilder.build());
            }
            return true;
        });
        Page commitPage = PageUtils.createPage(commits, (boolean)minimalCommitPage.getIsLastPage(), (PageRequest)pageRequestResolver.getPageRequest());
        Function<Commit, RestCommit> commitTransformer = commit -> {
            RestCommit restCommit = new RestCommit(commit);
            if (commit.getRepository() != null) {
                restCommit.put((Object)"repository", (Object)new RestRepository(commit.getRepository()));
            }
            return restCommit;
        };
        return ResponseFactory.ok((Object)new RestPage(commitPage, commitTransformer)).build();
    }

    @Path(value="projects/{projectKey}/repos/{repositorySlug}/forks")
    @GET
    @Timed(name="search.rest.resource.forks", absolute=true)
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response searchForks(@BeanParam RepositoryResolver repositoryResolver, @QueryParam(value="filter") String filter, @BeanParam PageRequestResolver pageRequestResolver, @Context ContainerRequestContext containerRequestContext) {
        DefaultRepositoryFilterRequest filterRequest = ((DefaultRepositoryFilterRequest.Builder)((DefaultRepositoryFilterRequest.Builder)DefaultRepositoryFilterRequest.builder().originId(repositoryResolver.getRepository().getId()).searchPagingInfo(((DefaultSearchPagingInfo.Builder)((DefaultSearchPagingInfo.Builder)DefaultSearchPagingInfo.builder().offset(pageRequestResolver.getPageRequest().getStart())).pageSize(pageRequestResolver.getPageRequest().getLimit())).build())).filter(StringUtils.trimToNull((String)filter))).build();
        return this.processRequest(filterRequest, ((Object)filterRequest).toString(), () -> this.searchService.filterRepositories(this.getSecurityContext(), filterRequest), result -> this.restConverter.convert((RepositorySearchResult)result, pageRequestResolver.getPageRequest(), containerRequestContext));
    }

    @Path(value="/repos-matching-root-file")
    @GET
    @Timed(name="search.rest.resource.repos.matching.root.file", absolute=true)
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response searchRepositoriesWithRootLevelFile(@QueryParam(value="rootFile") String rootFile, @QueryParam(value="query") String query, @BeanParam PageRequestResolver pageRequestResolver, @Context ContainerRequestContext containerRequestContext) {
        if ((rootFile = StringUtils.trimToNull((String)rootFile)) == null) {
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.search.rest.repositories.no.root.file", new Object[0]));
        }
        if (rootFile.contains("/")) {
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.search.rest.repositories.invalid.root.file", new Object[0]));
        }
        rootFile = rootFile.toLowerCase(Locale.ROOT);
        if ((query = StringUtils.trimToNull((String)query)) == null) {
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.search.rest.repositories.invalid.query", new Object[0]));
        }
        if (query.length() < 4) {
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.search.rest.repositories.invalid.query.length", new Object[0]));
        }
        DefaultRepositoryFileMatchingRequest repositoryFileMatchingRequest = ((DefaultRepositoryFileMatchingRequest.Builder)((Object)((DefaultRepositoryFileMatchingRequest.Builder)((Object)((DefaultRepositoryFileMatchingRequest.Builder)((Object)new DefaultRepositoryFileMatchingRequest.Builder().rootFileParameter(rootFile).rawSearchQuery(query))).searchPagingInfo(SearchRequest.SearchRequestType.REPOSITORIES, ((DefaultSearchPagingInfo.Builder)((DefaultSearchPagingInfo.Builder)DefaultSearchPagingInfo.builder().offset(0)).pageSize(MAX_SEARCH_PAGE_SIZE - 1)).build()))).searchPagingInfo(SearchRequest.SearchRequestType.CODE, ((DefaultSearchPagingInfo.Builder)((DefaultSearchPagingInfo.Builder)DefaultSearchPagingInfo.builder().offset(pageRequestResolver.getPageRequest().getStart())).pageSize(pageRequestResolver.getPageRequest().getLimit())).build()))).build();
        return this.processRequest(repositoryFileMatchingRequest, repositoryFileMatchingRequest.toString(), () -> this.searchService.searchRepositoriesMatchingFile(this.getSecurityContext(), repositoryFileMatchingRequest), result -> this.restConverter.convert((RepositorySearchResult)result, pageRequestResolver.getPageRequest(), containerRequestContext));
    }

    @Path(value="/repository-management")
    @GET
    @Timed(name="search.rest.resource.detailed.repos", absolute=true)
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response searchDetailedRepositories(@QueryParam(value="query") @DefaultValue(value="") String query, @QueryParam(value="sortOrder") @DefaultValue(value="SEARCH_SCORE") DetailedRepositorySortOrder detailedRepositorySortOrder, @QueryParam(value="hierarchyId") String hierarchyId, @QueryParam(value="personalProjectType") @DefaultValue(value="ALL") PersonalProjectType personalProjectType, @QueryParam(value="projectType") ProjectType projectType, @QueryParam(value="archived") RepositoryArchiveFilter archived, @QueryParam(value="recentActivityAfter") Long recentActivityAfter, @QueryParam(value="recentActivityBefore") Long recentActivityBefore, @QueryParam(value="minSize") Long minimumSize, @QueryParam(value="maxSize") Long maximumSize, @QueryParam(value="visibility") RepositoryVisibility visibility, @BeanParam PageRequestResolver pageRequestResolver, @Context ContainerRequestContext containerRequestContext) {
        this.featureManager.requireEnabled((Feature)StandardFeature.REPOSITORY_MANAGEMENT);
        DefaultDetailedRepositorySearchRequest searchRequest = ((DefaultDetailedRepositorySearchRequest.Builder)((Object)((DefaultDetailedRepositorySearchRequest.Builder)((Object)new DefaultDetailedRepositorySearchRequest.Builder().rawSearchQuery(query))).detailedRepositorySortOrder(detailedRepositorySortOrder).hierarchyId(hierarchyId).minimumSize(minimumSize).maximumSize(maximumSize).personalProjectType(personalProjectType).projectType(projectType).recentActivityAfter(recentActivityAfter == null ? null : Instant.ofEpochMilli(recentActivityAfter)).recentActivityBefore(recentActivityBefore == null ? null : Instant.ofEpochMilli(recentActivityBefore)).visibility(visibility).archived(archived).searchPagingInfo(SearchRequest.SearchRequestType.DETAILED_REPOSITORIES, ((DefaultSearchPagingInfo.Builder)((DefaultSearchPagingInfo.Builder)DefaultSearchPagingInfo.builder().offset(pageRequestResolver.getPageRequest().getStart())).pageSize(pageRequestResolver.getPageRequest().getLimit())).build()))).build();
        return this.processRequest(searchRequest, searchRequest.toString(), () -> this.searchService.searchDetailedRepositories(this.getSecurityContext(), searchRequest), result -> this.restConverter.convert((DetailedRepositorySearchResult)result, pageRequestResolver.getPageRequest(), containerRequestContext));
    }

    private static void logRequestTiming(String queryText, Stopwatch stopwatch) {
        stopwatch.stop();
        if (timingLogger.isDebugEnabled()) {
            timingLogger.debug("Timing: Search request execution took {} [{} ms] for query '{}'", new Object[]{stopwatch.toString(), stopwatch.elapsed(TimeUnit.MILLISECONDS), StringUtils.abbreviate((String)queryText, (int)250)});
        }
    }

    private SecurityContext getSecurityContext() {
        return this.hostSecurityService.resolveSecurityContext();
    }

    private void logSearchingError(Object requestObject, Exception error, String queryText) {
        for (Throwable localError = error; localError != null; localError = localError.getCause()) {
            if (localError instanceof QueryInvalidException) {
                log.debug("Unable to search due to invalid query '{}' - error: {}", (Object)queryText, (Object)error.getLocalizedMessage());
                return;
            }
            if (localError instanceof ConnectException) {
                log.debug("Connection exception: {}", (Object)localError.getMessage());
                return;
            }
            if (!(localError instanceof UnsuccessfulResponseException)) continue;
            log.error("Unexpected response code from the search server: {}", (Object)((UnsuccessfulResponseException)localError).getStatusCode());
            return;
        }
        log.error("Failed to process search request '{}' - error: {}", new Object[]{requestObject, error.toString(), log.isDebugEnabled() ? error : null});
    }

    private <T> Response processRequest(Object requestObject, String queryText, Supplier<Observable<T>> searchResultSupplier, Function<T, Object> restConverter) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        Observable<T> result = searchResultSupplier.get();
        return (Response)Observables.consumeSingle(result).fold(error -> {
            this.logSearchingError(requestObject, (Exception)error, queryText);
            SearchResource.logRequestTiming(queryText, stopwatch);
            throw Throwables.propagate((Throwable)error);
        }, searchResult -> {
            SearchResource.logRequestTiming(queryText, stopwatch);
            return Response.ok(restConverter.apply(searchResult)).build();
        });
    }
}

